/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.longmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.longmatrix.stub.AbstractDenseLongMatrix2D;

public class SimpleDenseLongMatrix2D
extends AbstractDenseLongMatrix2D {
    private static final long serialVersionUID = 2888746188860361425L;
    private long[][] values = null;

    public SimpleDenseLongMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof SimpleDenseLongMatrix2D) {
            long[][] v = ((SimpleDenseLongMatrix2D)m).values;
            this.values = new long[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new long[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsLong(m.getAsLong(c), c);
            }
        }
    }

    public SimpleDenseLongMatrix2D(long[] ... v) {
        this.values = v;
    }

    public SimpleDenseLongMatrix2D(long ... size) {
        this.values = new long[(int)size[0]][(int)size[1]];
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public long getLong(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setLong(long value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public long getLong(int row, int column) {
        return this.values[row][column];
    }

    public void setLong(long value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        long[][] result = new long[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new SimpleDenseLongMatrix2D(result);
    }
}

