/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileReader;

public abstract class ImportMatrixSPARSECSV {
    public static final Matrix fromString(String string, Object ... parameters) throws MatrixException {
        StringReader sr = new StringReader(string);
        IntelligentFileReader r = new IntelligentFileReader(sr);
        Matrix m = ImportMatrixSPARSECSV.fromReader(r, new Object[0]);
        r.close();
        return m;
    }

    public static final Matrix fromStream(InputStream stream, Object ... parameters) throws MatrixException, IOException {
        InputStreamReader r = new InputStreamReader(stream);
        Matrix m = ImportMatrixSPARSECSV.fromReader(r, parameters);
        r.close();
        return m;
    }

    public static final Matrix fromFile(File file, Object ... parameters) throws MatrixException, IOException {
        FileReader lr = new FileReader(file);
        Matrix m = ImportMatrixSPARSECSV.fromReader(lr, parameters);
        m.setLabel(file.getAbsolutePath());
        lr.close();
        return m;
    }

    public static final Matrix fromReader(Reader reader, Object ... parameters) throws MatrixException {
        ArrayList<Long> rowData = new ArrayList<Long>();
        ArrayList<Long> colData = new ArrayList<Long>();
        ArrayList<String> data = new ArrayList<String>();
        String separator = "[,;\t]";
        if (parameters.length == 1 && parameters[0] instanceof String) {
            separator = (String)parameters[0];
        }
        try {
            Pattern p = Pattern.compile(separator);
            IntelligentFileReader lr = new IntelligentFileReader(reader);
            long rows = 0L;
            long cols = 0L;
            String line = null;
            while ((line = lr.readLine()) != null) {
                String[] fields;
                if (line.length() <= 0 || (fields = p.split(line)).length != 3) continue;
                long row = Long.parseLong(fields[0]);
                long col = Long.parseLong(fields[1]);
                String s = fields[2];
                if (row > rows) {
                    rows = row;
                }
                if (col > cols) {
                    cols = col;
                }
                rowData.add(row);
                colData.add(col);
                data.add(s);
            }
            lr.close();
            Matrix m = MatrixFactory.sparse(ValueType.STRING, rows + 1L, cols + 1L);
            int i = 0;
            while (i < data.size()) {
                long row = (Long)rowData.get(i);
                long col = (Long)colData.get(i);
                String s = (String)data.get(i);
                m.setAsString(s, row, col);
                ++i;
            }
            return m;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }
}

