/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix2D;

public class SimpleDenseIntMatrix2D
extends AbstractDenseIntMatrix2D {
    private static final long serialVersionUID = -3331102463077119410L;
    private int[][] values = null;

    public SimpleDenseIntMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof SimpleDenseIntMatrix2D) {
            int[][] v = ((SimpleDenseIntMatrix2D)m).values;
            this.values = new int[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new int[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsDouble(m.getAsDouble(c), c);
            }
        }
    }

    public SimpleDenseIntMatrix2D(int[] ... v) {
        this.values = v;
    }

    public SimpleDenseIntMatrix2D(long ... size) {
        this.values = new int[(int)size[0]][(int)size[1]];
    }

    public SimpleDenseIntMatrix2D(int[] v) {
        this.values = new int[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public int getInt(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setInt(int value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public int getInt(int row, int column) {
        return this.values[row][column];
    }

    public void setInt(int value, int row, int column) {
        this.values[row][column] = value;
    }

    public final IntMatrix transpose() {
        int[][] result = new int[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix plus(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] + vInt;
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix minus(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] - vInt;
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix times(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] * vInt;
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix divide(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] / vInt;
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix plus(IntMatrix m2) throws MatrixException {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] + m2.getAsInt(r, c);
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix minus(IntMatrix m2) throws MatrixException {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] - m2.getAsInt(r, c);
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix times(IntMatrix m2) throws MatrixException {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] * m2.getAsInt(r, c);
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public final IntMatrix divide(IntMatrix m2) throws MatrixException {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] / m2.getAsInt(r, c);
            }
        }
        return new SimpleDenseIntMatrix2D(result);
    }

    public IntMatrix mtimes(IntMatrix matrix) throws MatrixException {
        if ((long)this.values[0].length != matrix.getRowCount()) {
            throw new MatrixException("matrices have wrong size: " + Coordinates.toString(this.getSize()) + " and " + Coordinates.toString(matrix.getSize()));
        }
        int[][] ret = new int[this.values.length][(int)matrix.getColumnCount()];
        int i = this.values.length;
        while (--i >= 0) {
            int j = ret[0].length;
            while (--j >= 0) {
                int sum = 0;
                int k = this.values[0].length;
                while (--k >= 0) {
                    sum = (int)((double)sum + (double)this.values[i][k] * matrix.getAsDouble(k, j));
                }
                ret[i][j] = sum;
            }
        }
        return new SimpleDenseIntMatrix2D(ret);
    }

    public boolean containsNaN() {
        int r = this.values.length;
        while (--r >= 0) {
            int c = this.values[0].length;
            while (--c >= 0) {
                if (!Double.isNaN(this.values[r][c])) continue;
                return true;
            }
        }
        return false;
    }
}

