/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.BufferedRandomAccessFile;

public class DenseFileMatrix2D
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = 1754729146021609978L;
    private transient BufferedRandomAccessFile randomAccessFile = null;
    public static final int BYTE = 0;
    public static final int CHAR = 1;
    public static final int DOUBLE = 2;
    public static final int FLOAT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int SHORT = 6;
    public static final int UNSIGNEDBYTE = 7;
    public static final int UNSIGNEDSHORT = 8;
    public static final int SHORTLITTLEENDIAN = 9;
    public static final int INTLITTLEENDIAN = 10;
    public static final int LONGLITTLEENDIAN = 11;
    public static final int BOOLEAN = 12;
    private int dataType = 2;
    private File file = null;
    private long rowCount = 0L;
    private long columnCount = 0L;
    private long offset = 0L;
    private int bitsPerValue = 1;
    private boolean readOnly = false;
    private static ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public DenseFileMatrix2D(File file, long rowCount, long columnCount) throws IOException {
        this(file, rowCount, columnCount, 0L, 2, false);
    }

    public DenseFileMatrix2D(File file) throws IOException {
        this(file, file.length(), 1L, 0L, 0, true);
    }

    public DenseFileMatrix2D(File file, long rowCount, long columnCount, int dataType) throws IOException {
        this(file, rowCount, columnCount, 0L, dataType, false);
    }

    public DenseFileMatrix2D(File file, long rowCount, long columnCount, long offset, int dataType, boolean readOnly) throws IOException {
        if (file == null) {
            file = File.createTempFile("denseFileMatrix", "dat");
            file.deleteOnExit();
        }
        this.file = file;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.offset = offset;
        this.dataType = dataType;
        this.bitsPerValue = DenseFileMatrix2D.getBitsPerValue(dataType);
        this.readOnly = readOnly;
    }

    private void createFile() {
        block21: {
            try {
                if (this.readOnly) {
                    this.randomAccessFile = new BufferedRandomAccessFile(this.file, "r");
                    break block21;
                }
                try {
                    this.randomAccessFile = new BufferedRandomAccessFile(this.file, "rw");
                }
                catch (FileNotFoundException e) {
                    this.randomAccessFile = new BufferedRandomAccessFile(this.file, "r");
                }
                long difference = this.getFileLength() + this.offset - this.randomAccessFile.length();
                if (difference > 0L) {
                    long seek = (long)Math.ceil(this.getPos(this.getRowCount(), this.getColumnCount()));
                    switch (this.dataType) {
                        case 0: {
                            this.randomAccessFile.writeByte(seek, (byte)0);
                            break;
                        }
                        case 1: {
                            this.randomAccessFile.writeChar(seek, '\u0000');
                            break;
                        }
                        case 2: {
                            this.randomAccessFile.writeDouble(seek, 0.0);
                            break;
                        }
                        case 3: {
                            this.randomAccessFile.writeFloat(seek, 0.0f);
                            break;
                        }
                        case 6: {
                            this.randomAccessFile.writeShort(seek, (short)0);
                            break;
                        }
                        case 4: {
                            this.randomAccessFile.writeInt(seek, 0);
                            break;
                        }
                        case 5: {
                            this.randomAccessFile.writeLong(seek, 0L);
                            break;
                        }
                        case 7: {
                            this.randomAccessFile.writeByte(seek, (byte)0);
                            break;
                        }
                        case 8: {
                            this.randomAccessFile.writeShort(seek, (short)0);
                            break;
                        }
                        case 10: {
                            this.randomAccessFile.writeInt(seek, 0);
                            break;
                        }
                        case 9: {
                            this.randomAccessFile.writeInt(seek, 0);
                            break;
                        }
                        case 11: {
                            this.randomAccessFile.writeLong(seek, 0L);
                            break;
                        }
                        case 12: {
                            this.randomAccessFile.writeByte(seek, (byte)0);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new MatrixException("could not open file", e);
            }
        }
    }

    public DenseFileMatrix2D(long rowCount, long columnCount) throws IOException {
        this(rowCount, columnCount, 2);
    }

    public DenseFileMatrix2D(long ... size) throws IOException {
        this(size[0], size[1], 2);
    }

    public DenseFileMatrix2D(Matrix m) throws IOException {
        this(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    public DenseFileMatrix2D(long rowCount, long columnCount, int dataType) throws IOException {
        this(null, rowCount, columnCount, dataType);
    }

    public BufferedRandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public void setColumnCount(int colCount) {
        this.columnCount = colCount;
    }

    public File getFile() {
        return this.file;
    }

    private static final int getBitsPerValue(int dataType) {
        switch (dataType) {
            case 0: {
                return 8;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 64;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 32;
            }
            case 10: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 11: {
                return 64;
            }
            case 6: {
                return 16;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 16;
            }
            case 12: {
                return 1;
            }
        }
        return 32;
    }

    public double getBytesPerValue() {
        return (double)this.getBitsPerValue() / 8.0;
    }

    public int getBitsPerValue() {
        return this.bitsPerValue;
    }

    private double getPos(long row, long column) {
        if (this.getBytesPerValue() < 1.0) {
            return (double)row * (double)this.columnCount * this.getBytesPerValue() + (double)column * this.getBytesPerValue() + (double)this.offset;
        }
        return (double)(row * this.columnCount) * this.getBytesPerValue() + (double)column * this.getBytesPerValue() + (double)this.offset;
    }

    public long getFileLength() {
        double prod = (double)this.getRowCount() * (double)this.getColumnCount() * this.getBytesPerValue();
        return (long)Math.ceil(prod);
    }

    public int getDataType() {
        return this.dataType;
    }

    public synchronized double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    public synchronized double getDouble(long row, long column) {
        block20: {
            if (this.randomAccessFile == null) {
                this.createFile();
            }
            if (this.randomAccessFile != null) {
                try {
                    double pos = this.getPos(row, column);
                    if (pos < (double)(this.getFileLength() + this.offset)) {
                        long seek = (long)Math.floor(pos);
                        byte[] bytes = null;
                        switch (this.getDataType()) {
                            case 0: {
                                bytes = new byte[1];
                                this.randomAccessFile.read(seek, bytes);
                                return bytes[0];
                            }
                            case 1: {
                                bytes = new byte[1];
                                this.randomAccessFile.read(seek, bytes);
                                return bytes[0];
                            }
                            case 2: {
                                bytes = new byte[8];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getDouble();
                            }
                            case 3: {
                                bytes = new byte[4];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getFloat();
                            }
                            case 6: {
                                bytes = new byte[2];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getShort();
                            }
                            case 4: {
                                bytes = new byte[4];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getInt();
                            }
                            case 5: {
                                bytes = new byte[8];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getLong();
                            }
                            case 11: {
                                bytes = new byte[8];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getLong();
                            }
                            case 9: {
                                bytes = new byte[2];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getShort();
                            }
                            case 10: {
                                bytes = new byte[4];
                                this.randomAccessFile.read(seek, bytes);
                                return ByteBuffer.wrap(bytes).order(byteOrder).getInt();
                            }
                            case 7: {
                                return this.randomAccessFile.readUnsignedByte();
                            }
                            case 8: {
                                return this.randomAccessFile.readUnsignedShort();
                            }
                            case 12: {
                                return DenseFileMatrix2D.getBit(this.randomAccessFile.readByte(), pos - Math.floor(pos));
                            }
                        }
                        break block20;
                    }
                    throw new MatrixException("no such coordinates: " + row + "," + column);
                }
                catch (Exception e) {
                    throw new MatrixException("could not read value", e);
                }
            }
        }
        return 0.0;
    }

    private static final double getBit(byte b, double offset) {
        if (offset == 0.0) {
            return (b & 1) > 0 ? 1 : 0;
        }
        if (offset == 0.125) {
            return (b & 2) > 0 ? 1 : 0;
        }
        if (offset == 0.25) {
            return (b & 4) > 0 ? 1 : 0;
        }
        if (offset == 0.375) {
            return (b & 8) > 0 ? 1 : 0;
        }
        if (offset == 0.5) {
            return (b & 0x10) > 0 ? 1 : 0;
        }
        if (offset == 0.625) {
            return (b & 0x20) > 0 ? 1 : 0;
        }
        if (offset == 0.75) {
            return (b & 0x40) > 0 ? 1 : 0;
        }
        if (offset == 0.875) {
            return (b & 0x80) > 0 ? 1 : 0;
        }
        return 0.0;
    }

    private static final byte setBit(byte b, double offset) {
        if (offset == 0.0) {
            b = (byte)(b | 1);
        } else if (offset == 0.125) {
            b = (byte)(b | 2);
        } else if (offset == 0.25) {
            b = (byte)(b | 4);
        } else if (offset == 0.375) {
            b = (byte)(b | 8);
        } else if (offset == 0.5) {
            b = (byte)(b | 0x10);
        } else if (offset == 0.625) {
            b = (byte)(b | 0x20);
        } else if (offset == 0.75) {
            b = (byte)(b | 0x40);
        } else if (offset == 0.875) {
            b = (byte)(b | 0x80);
        }
        return b;
    }

    public synchronized void setDouble(double value, int row, int column) {
        this.setDouble(value, (long)row, (long)column);
    }

    public synchronized void setDouble(double value, long row, long column) {
        if (this.isReadOnly()) {
            return;
        }
        try {
            if (this.file == null) {
                this.file = File.createTempFile("matrix", null);
            }
            if (this.randomAccessFile == null) {
                this.createFile();
            }
            double pos = this.getPos(row, column);
            long seek = (long)Math.floor(pos);
            ByteBuffer bb = null;
            switch (this.dataType) {
                case 0: {
                    this.randomAccessFile.writeByte(seek, (byte)value);
                    break;
                }
                case 1: {
                    this.randomAccessFile.writeChar(seek, (char)value);
                    break;
                }
                case 2: {
                    this.randomAccessFile.writeDouble(seek, value);
                    break;
                }
                case 3: {
                    this.randomAccessFile.writeFloat(seek, (float)value);
                    break;
                }
                case 6: {
                    this.randomAccessFile.writeShort(seek, (short)value);
                    break;
                }
                case 9: {
                    bb = ByteBuffer.allocate(2).order(byteOrder);
                    bb.putShort((short)value);
                    this.randomAccessFile.write(seek, bb.array());
                    break;
                }
                case 4: {
                    this.randomAccessFile.writeInt(seek, (int)value);
                    break;
                }
                case 10: {
                    bb = ByteBuffer.allocate(4).order(byteOrder);
                    bb.putInt((int)value);
                    this.randomAccessFile.write(seek, bb.array());
                    break;
                }
                case 5: {
                    this.randomAccessFile.writeLong(seek, (long)value);
                    break;
                }
                case 11: {
                    bb = ByteBuffer.allocate(8).order(byteOrder);
                    bb.putLong((long)value);
                    this.randomAccessFile.write(seek, bb.array());
                    break;
                }
                case 7: {
                    this.randomAccessFile.writeByte(seek, (byte)value);
                    break;
                }
                case 8: {
                    this.randomAccessFile.writeShort(seek, (short)value);
                    break;
                }
                case 12: {
                    throw new IOException("not supported");
                }
            }
        }
        catch (Exception e) {
            throw new MatrixException("could not write value at coordinates " + row + "," + column, e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long[] getSize() {
        return new long[]{this.rowCount, this.columnCount};
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static final int getShortLittleEndian(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(byteOrder).getShort();
    }

    public static final int getIntLittleEndian(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(byteOrder).getInt();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (long[] c : this.availableCoordinates()) {
            s.writeObject(new Coordinates(c));
            s.writeObject(this.getDouble(c));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            while (true) {
                Coordinates c = (Coordinates)s.readObject();
                Double o = (Double)s.readObject();
                this.setDouble((double)o, c.dimensions);
            }
        }
        catch (OptionalDataException e) {
            return;
        }
    }
}

