/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class AddMissing
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8211102877475985639L;
    private double[] percentMissing = null;
    private Matrix missingValues = null;

    public AddMissing(int dimension, Matrix source, double ... percentMissing) {
        super(dimension, source);
        if (percentMissing.length == 1 && dimension != Integer.MAX_VALUE) {
            this.percentMissing = new double[(int)this.getSource().getSize(dimension)];
            Arrays.fill(this.percentMissing, percentMissing[0]);
        } else {
            this.percentMissing = percentMissing;
        }
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.missingValues == null) {
            this.missingValues = MatrixFactory.sparse(this.getSource().getSize());
            switch (this.getDimension()) {
                case 0x7FFFFFFF: {
                    int count = (int)(this.percentMissing[0] * (double)Coordinates.product(this.getSource().getSize()));
                    int i = 0;
                    while (i < count) {
                        double v = 0.0;
                        int r = 0;
                        int c = 0;
                        do {
                            r = MathUtil.nextInteger(0, (int)this.getSource().getRowCount() - 1);
                            c = MathUtil.nextInteger(0, (int)this.getSource().getColumnCount() - 1);
                        } while (MathUtil.isNaNOrInfinite(v = this.missingValues.getAsDouble(r, c)));
                        this.missingValues.setAsDouble(Double.NaN, r, c);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int missingCount = (int)((double)this.getSource().getColumnCount() * this.percentMissing[0]);
                    long r = this.getSource().getRowCount() - 1L;
                    while (r != -1L) {
                        int i = 0;
                        while (i < missingCount) {
                            double v = 0.0;
                            int c = 0;
                            do {
                                c = MathUtil.nextInteger(0, (int)this.getSource().getColumnCount() - 1);
                            } while (MathUtil.isNaNOrInfinite(v = this.missingValues.getAsDouble(r, c)));
                            this.missingValues.setAsDouble(Double.NaN, r, c);
                            ++i;
                        }
                        --r;
                    }
                    break;
                }
            }
        }
        if (this.missingValues.contains(coordinates)) {
            return Double.NaN;
        }
        return this.getSource().getAsDouble(coordinates);
    }
}

