/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.QR;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Solve<T> {
    public static final int THRESHOLD = 100;
    public static final Solve<Matrix> MATRIX = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(a, b);
                }
                return MATRIXSMALLSINGLETHREADED.calc(a, b);
            }
            if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(a, b);
            }
            return MATRIXSMALLMULTITHREADED.calc(a, b);
        }
    };
    public static final Solve<Matrix> INSTANCE = MATRIX;
    public static final Solve<Matrix> UJMP = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            return a.isSquare() ? LU.INSTANCE.solve(a, b) : QR.INSTANCE.solve(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final Solve<Matrix> MATRIXLARGESINGLETHREADED = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            Solve solve = DecompositionOps.SOLVE_OJALGO;
            if (solve == null) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null) {
                solve = DecompositionOps.SOLVE_MTJ;
            }
            if (solve == null) {
                solve = UJMP;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXLARGEMULTITHREADED = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            Solve solve = DecompositionOps.SOLVE_OJALGO;
            if (solve == null) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null) {
                solve = UJMP;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXSMALLMULTITHREADED = UJMP;

    public T calc(T var1, T var2);
}

