/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Chol<T> {
    public static final int THRESHOLD = 700;
    public static final Chol<Matrix> MATRIX = new Chol<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 700L && source.getColumnCount() >= 700L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 700L && source.getColumnCount() >= 700L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 700L && source.getColumnCount() >= 700L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 700L && source.getColumnCount() >= 700L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final Chol<Matrix> INSTANCE = MATRIX;
    public static final Chol<Matrix> UJMP = new Chol<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            CholMatrix chol = new CholMatrix(source);
            return chol.getL();
        }

        @Override
        public Matrix solve(Matrix source, Matrix b) {
            CholMatrix chol = new CholMatrix(source);
            return chol.solve(b);
        }
    };
    public static final Chol<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final Chol<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final Chol<Matrix> MATRIXLARGESINGLETHREADED = UJMP;
    public static final Chol<Matrix> MATRIXLARGEMULTITHREADED = new Chol<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Chol chol = DecompositionOps.CHOL_OJALGO;
            if (chol == null) {
                chol = UJMP;
            }
            return chol.calc(source);
        }

        @Override
        public Matrix solve(Matrix source, Matrix b) {
            Chol chol = DecompositionOps.CHOL_OJALGO;
            if (chol == null) {
                chol = UJMP;
            }
            return chol.solve(source, b);
        }
    };

    public T calc(T var1);

    public T solve(T var1, T var2);

    public static class CholMatrix {
        private static final long serialVersionUID = 400514872358216115L;
        private double[][] L;
        private int n;
        private boolean isspd;

        public CholMatrix(Matrix Arg) {
            double[][] A = Arg.toDoubleArray();
            this.n = (int)Arg.getRowCount();
            this.L = new double[this.n][this.n];
            this.isspd = Arg.getColumnCount() == (long)this.n;
            double[] Lrowj = null;
            double[] Lrowk = null;
            double[] Aj = null;
            int j = 0;
            while (j < this.n) {
                Lrowj = this.L[j];
                Aj = A[j];
                double d = 0.0;
                int k = 0;
                while (k < j) {
                    Lrowk = this.L[k];
                    double s = 0.0;
                    int i = 0;
                    while (i < k) {
                        s += Lrowk[i] * Lrowj[i];
                        ++i;
                    }
                    Lrowj[k] = s = (Aj[k] - s) / Lrowk[k];
                    d += s * s;
                    this.isspd &= A[k][j] == Aj[k];
                    ++k;
                }
                this.isspd &= (d = Aj[j] - d) > 0.0;
                Lrowj[j] = StrictMath.sqrt(StrictMath.max(d, 0.0));
                k = j + 1;
                while (k < this.n) {
                    Lrowj[k] = 0.0;
                    ++k;
                }
                ++j;
            }
        }

        public boolean isSPD() {
            return this.isspd;
        }

        public Matrix getL() {
            return MatrixFactory.linkToArray(this.L).transpose();
        }

        public Matrix solve(Matrix B) {
            int i;
            int j;
            if (B.getRowCount() != (long)this.n) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isspd) {
                throw new RuntimeException("Matrix is not symmetric positive definite.");
            }
            double[][] X = B.toDoubleArray();
            int nx = (int)B.getColumnCount();
            int k = 0;
            while (k < this.n) {
                j = 0;
                while (j < nx) {
                    i = 0;
                    while (i < k) {
                        double[] dArray = X[k];
                        int n = j;
                        dArray[n] = dArray[n] - X[i][j] * this.L[k][i];
                        ++i;
                    }
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.L[k][k];
                }
                ++k;
            }
            k = this.n - 1;
            while (k >= 0) {
                j = 0;
                while (j < nx) {
                    i = k + 1;
                    while (i < this.n) {
                        double[] dArray = X[k];
                        int n = j;
                        dArray[n] = dArray[n] - X[i][j] * this.L[i][k];
                        ++i;
                    }
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.L[k][k];
                }
                --k;
            }
            return MatrixFactory.linkToArray(X);
        }
    }
}

