/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.creators;

import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public class Eye
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 2547827499345834225L;

    public Eye(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) {
        return coordinates[0] == coordinates[1] ? 1.0 : 0.0;
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(source.getSize());
        long[] c = Coordinates.copyOf(source.getSize());
        int i = 0;
        while (Coordinates.isSmallerThan(c, source.getSize())) {
            Arrays.fill(c, (long)i);
            ret.setAsDouble(1.0, c);
            ++i;
        }
        return ret;
    }

    public static Matrix calc(long ... size) throws MatrixException {
        return Eye.calc(ValueType.DOUBLE, size);
    }

    public static Matrix calc(ValueType valueType, long ... size) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(valueType, size);
        long[] c = new long[size.length];
        int i = 0;
        while (Coordinates.isSmallerThan(c, size)) {
            ret.setAsDouble(1.0, c);
            Arrays.fill(c, (long)(i + 1));
            ++i;
        }
        return ret;
    }
}

