/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Sqrt
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8139556053923421840L;

    public Sqrt(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.sqrt(this.getSource().getAsDouble(coordinates));
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.sqrt(source.getAsDouble(c)), c);
        }
        return ret;
    }
}

