/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Transpose<T> {
    public static final Transpose<Matrix> INSTANCE = new Transpose<Matrix>(){

        @Override
        public void calc(Matrix source, Matrix target) {
            if (source == target) {
                throw new MatrixException("cannot transpose into original matrix");
            }
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, (SparseMatrix)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    Object o = source.getAsObject(c);
                    target.setAsObject(o, Coordinates.transpose(c));
                }
            }
        }
    };
    public static final Transpose<DenseMatrix> DENSEMATRIX = new Transpose<DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, (DenseMatrix2D)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    Object o = source.getAsObject(c);
                    target.setAsObject(o, Coordinates.transpose(c));
                }
            }
        }
    };
    public static final Transpose<SparseMatrix> SPARSEMATRIX = new Transpose<SparseMatrix>(){

        @Override
        public void calc(SparseMatrix source, SparseMatrix target) {
            for (long[] c : source.availableCoordinates()) {
                Object o = source.getAsObject(c);
                target.setAsObject(o, Coordinates.transpose(c));
            }
        }
    };
    public static final Transpose<DenseMatrix2D> DENSEMATRIX2D = new Transpose<DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, (DenseDoubleMatrix2D)target);
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        Object o = source.getAsObject(r, c);
                        target.setAsObject(o, c, r);
                    }
                }
            }
        }
    };
    public static final Transpose<DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new Transpose<DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source, DenseDoubleMatrix2D target) {
            if (source instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calc(((HasDoubleArray2D)((Object)source)).getDoubleArray2D(), ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.calc((int)source.getRowCount(), (int)source.getColumnCount(), ((HasDoubleArray)((Object)source)).getDoubleArray(), ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        target.setDouble(source.getDouble(r, c), c, r);
                    }
                }
            }
        }

        @Override
        private void calc(final double[][] source, final double[][] target) {
            final int retcols = source.length;
            int retrows = source[0].length;
            if (retcols * retrows > 10000) {
                new PFor(0, retrows - 1, new Object[0]){

                    public void step(int i) {
                        int c = 0;
                        while (c < retcols) {
                            target[i][c] = source[c][i];
                            ++c;
                        }
                    }
                };
            } else {
                int r = 0;
                while (r < retrows) {
                    int c = 0;
                    while (c < retcols) {
                        target[r][c] = source[c][r];
                        ++c;
                    }
                    ++r;
                }
            }
        }

        private void calc(final int rows, final int cols, final double[] source, final double[] target) {
            if (source.length > 10000) {
                new PFor(0, rows - 1, new Object[0]){

                    public void step(int i) {
                        int r = 0;
                        while (r < cols) {
                            target[i * cols + r] = source[r * rows + i];
                            ++r;
                        }
                    }
                };
            } else {
                int c = 0;
                while (c < rows) {
                    int r = 0;
                    while (r < cols) {
                        target[c * cols + r] = source[r * rows + c];
                        ++r;
                    }
                    ++c;
                }
            }
        }
    };

    public void calc(T var1, T var2);
}

