/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasDoubleArray;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TimesScalar<T> {
    public static final TimesScalar<Matrix> INSTANCE = new TimesScalar<Matrix>(){

        @Override
        public void calc(Matrix source, BigDecimal factor, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, factor, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, factor, (SparseMatrix)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal value = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.times(value, factor);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(Matrix source, double factor, Matrix target) {
            if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
                DENSEMATRIX.calc((DenseMatrix)source, factor, (DenseMatrix)target);
            } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
                SPARSEMATRIX.calc((SparseMatrix)source, factor, (SparseMatrix)target);
            } else {
                this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final TimesScalar<DenseMatrix> DENSEMATRIX = new TimesScalar<DenseMatrix>(){

        @Override
        public void calc(DenseMatrix source, BigDecimal factor, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, factor, (DenseMatrix2D)target);
            } else {
                for (long[] c : source.allCoordinates()) {
                    BigDecimal value = source.getAsBigDecimal(c);
                    BigDecimal result = MathUtil.times(value, factor);
                    target.setAsBigDecimal(result, c);
                }
            }
        }

        @Override
        public void calc(DenseMatrix source, double factor, DenseMatrix target) {
            if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
                DENSEMATRIX2D.calc((DenseMatrix2D)source, factor, (DenseMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final TimesScalar<SparseMatrix> SPARSEMATRIX = new TimesScalar<SparseMatrix>(){

        @Override
        public void calc(SparseMatrix source, BigDecimal factor, SparseMatrix target) {
            for (long[] c : source.availableCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.times(value, factor);
                target.setAsBigDecimal(result, c);
            }
        }

        @Override
        public void calc(SparseMatrix source, double factor, SparseMatrix target) {
            this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
        }
    };
    public static final TimesScalar<DenseMatrix2D> DENSEMATRIX2D = new TimesScalar<DenseMatrix2D>(){

        @Override
        public void calc(DenseMatrix2D source, BigDecimal factor, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, factor, (DenseDoubleMatrix2D)target);
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        BigDecimal value = source.getAsBigDecimal(r, c);
                        BigDecimal result = MathUtil.times(value, factor);
                        target.setAsBigDecimal(result, r, c);
                    }
                }
            }
        }

        @Override
        public void calc(DenseMatrix2D source, double factor, DenseMatrix2D target) {
            if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
                DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, factor, (DenseDoubleMatrix2D)target);
            } else {
                this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
            }
        }
    };
    public static final TimesScalar<DenseDoubleMatrix2D> DENSEDOUBLEMATRIX2D = new TimesScalar<DenseDoubleMatrix2D>(){

        @Override
        public void calc(DenseDoubleMatrix2D source, BigDecimal factor, DenseDoubleMatrix2D target) {
            this.calc(source, factor.doubleValue(), target);
        }

        @Override
        public void calc(DenseDoubleMatrix2D source, double factor, DenseDoubleMatrix2D target) {
            if (source instanceof HasDoubleArray2D && target instanceof HasDoubleArray2D) {
                this.calc(((HasDoubleArray2D)((Object)source)).getDoubleArray2D(), factor, ((HasDoubleArray2D)((Object)target)).getDoubleArray2D());
            } else if (source instanceof HasDoubleArray && target instanceof HasDoubleArray) {
                this.calc(((HasDoubleArray)((Object)source)).getDoubleArray(), factor, ((HasDoubleArray)((Object)target)).getDoubleArray());
            } else {
                int r = (int)source.getRowCount();
                while (--r != -1) {
                    int c = (int)source.getColumnCount();
                    while (--c != -1) {
                        target.setDouble(factor * source.getDouble(r, c), r, c);
                    }
                }
            }
        }

        @Override
        private void calc(final double[][] source, final double factor, final double[][] target) {
            int rows = source.length;
            final int cols = source[0].length;
            if (UJMPSettings.getNumberOfThreads() > 1 && rows >= 100 && cols >= 100) {
                new PForEquidistant(0, rows - 1, new Object[0]){

                    public void step(int i) {
                        double[] tsource = source[i];
                        double[] ttarget = target[i];
                        int c = 0;
                        while (c < cols) {
                            ttarget[c] = tsource[c] * factor;
                            ++c;
                        }
                    }
                };
            } else {
                double[] tsource = null;
                double[] ttarget = null;
                int r = 0;
                while (r < rows) {
                    tsource = source[r];
                    ttarget = target[r];
                    int c = 0;
                    while (c < cols) {
                        ttarget[c] = tsource[c] * factor;
                        ++c;
                    }
                    ++r;
                }
            }
        }

        @Override
        private void calc(double[] source, double factor, double[] target) {
            int length = source.length;
            int i = 0;
            while (i < length) {
                target[i] = source[i] * factor;
                ++i;
            }
        }
    };

    public void calc(T var1, BigDecimal var2, T var3);

    public void calc(T var1, double var2, T var4);
}

