/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.calculation;

import java.math.BigInteger;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.bigintegermatrix.BigIntegerMatrix;
import org.ujmp.core.bigintegermatrix.calculation.BigIntegerCalculation;
import org.ujmp.core.bigintegermatrix.impl.BigIntegerCalculationMatrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractBigIntegerCalculation
extends AbstractCalculation
implements BigIntegerCalculation {
    private static final long serialVersionUID = 6820193205334660103L;

    public AbstractBigIntegerCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractBigIntegerCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final BigIntegerMatrix calcNew() throws MatrixException {
        BigIntegerMatrix result = (BigIntegerMatrix)MatrixFactory.zeros(ValueType.BIGINTEGER, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsBigInteger(this.getBigInteger(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final BigIntegerMatrix calcLink() throws MatrixException {
        return new BigIntegerCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsBigInteger(this.getBigInteger(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setBigInteger(BigInteger value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.BIGINTEGER;
    }
}

