/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.AbstractBenchmarkTask;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.util.GCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolveSquareBenchmarkTask
extends AbstractBenchmarkTask {
    public SolveSquareBenchmarkTask(long benchmarkSeed, Class<? extends DoubleMatrix2D> matrixClass, BenchmarkConfig config) {
        super(benchmarkSeed, matrixClass, config.getSolveSquareSizes(), config);
    }

    @Override
    public double task(Class<? extends Matrix> matrixClass, long benchmarkSeed, int run, long[] size) {
        long t1;
        long t0;
        block5: {
            Matrix result;
            DoubleMatrix2D b2;
            Matrix b1;
            DenseDoubleMatrix2D x;
            DoubleMatrix2D a;
            block4: {
                a = null;
                x = null;
                b1 = null;
                b2 = null;
                result = null;
                try {
                    a = BenchmarkUtil.createMatrix(matrixClass, size);
                    if (a.getClass().getName().startsWith("org.ujmp.core.") || a.getClass().getDeclaredMethod("solve", Matrix.class) != null) break block4;
                    System.out.print("-");
                    System.out.flush();
                    return 0.0;
                }
                catch (Throwable e) {
                    System.out.print("e");
                    System.out.flush();
                    return Double.NaN;
                }
            }
            x = DenseDoubleMatrix2D.factory.dense(size[1], size[0]);
            BenchmarkUtil.rand(benchmarkSeed, run, 0, a);
            BenchmarkUtil.rand(benchmarkSeed, run, 1, x);
            b1 = new DefaultDenseDoubleMatrix2D(a).mtimes(new DefaultDenseDoubleMatrix2D(x));
            b2 = BenchmarkUtil.createMatrix(matrixClass, b1);
            GCUtil.purgeMemory();
            t0 = System.nanoTime();
            result = a.solve(b2);
            t1 = System.nanoTime();
            if (result != null) break block5;
            System.out.print("e");
            System.out.flush();
            return Double.NaN;
        }
        return (double)(t1 - t0) / 1000000.0;
    }

    @Override
    public String getTaskName() {
        return "solveSquare";
    }
}

