% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.

function t = findSkelOrient(x, y)


%% Distances
pwDist = squareform(pdist([x, y]));
pwDist = diag(inf(numel(x), 1)) + pwDist;

% Sort them
[~, sortDistIDX] = sort(pwDist, 2);


%% Orientations
distX = x(sortDistIDX(:, 1)) - x(sortDistIDX(:, 2));
distY = y(sortDistIDX(:, 1)) - y(sortDistIDX(:, 2));
t = mod(atan2(distY, distX), pi);

end
