% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.

function isPivot = findPivots(x, y)


%% Prepare
numOfPoints = numel(x);
numOfPivots = round(0.1 * numOfPoints);
tmp = min(numOfPoints,400); numOfPivots = max(numOfPivots,tmp); clear tmp % 400 points picked as the pivots points

% Random subset
randP = randperm(numOfPoints);
subSet = randP(1 : min(3 * numOfPivots, numOfPoints));

% Pairwise distances
pwDist = squareform(pdist([x(subSet), y(subSet)]));
pwDist = diag(inf(numel(subSet), 1)) + pwDist;


%% Pivots
isPivot = false(numOfPoints, 1);
isPivot(subSet) = true;
while (sum(isPivot) > numOfPivots)
    [minY, ~] = min(pwDist);
    [~, minIDx] = min(minY);
    pwDist( :, minIDx ) = inf;
    pwDist( minIDx, : ) = inf;
    isPivot(subSet(minIDx)) = false;
end

end
