% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.


% %% Add paths
% if (~isdeployed)
	addpath('./loadShape/')
	addpath('./descriptors/')
% end

% set parameters for computing the HOOSC descriptor

global option;

option.NumberRing = 2; % Number of rings, recommend 2 rings;
option.ringsize = 1; % ratio of the size of the outer ring to that of the average distance between pair-wise pivot points of the shape, 
                     % typical options: 
                     % 1 (outer ring size equals to the average distance between pair-wise pivots points),
                     % 0.5 (half the average distance between pair-wise pivot points),
                     % 0.25 (a quater of the average distance between pair-wise pivot points)
option.pos = 0; % binary options indicting whether pivot position information will be encoded in the descriptor, 
                % '1' position informaion will be included, 
                % '0' position information will not be included;

fileName = 'A1a.png'; % input 

%% Compute the descriptor
descr = computeDescriptor(fileName);


