% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.

function skel = gray2skel(glyphRGB)


%% Normalize the format to grayScale (0, 1)
if (numel(size(glyphRGB)) == 3)
    glyphRGB = rgb2gray(glyphRGB);
end
glyphGray = double(glyphRGB);
glyphGray = glyphGray / max(glyphGray(:));


%% Inscribe the image in a standar frame
[numOfRows, numOfCols] = size(glyphGray);
glyphGray = [ones(10, numOfCols + 20);...
    ones(numOfRows, 10), glyphGray, ones(numOfRows, 10);...
    ones(10, numOfCols + 20)];


%% Scale to fit 256 pixels in the largest side
scl = 256 / (max(numOfRows, numOfCols) + 20);
glyphGray = imresize(glyphGray, scl);

%% binarization
bw = glyphGray; bw(bw<0.96) = 0;
skel_bridge=bwmorph(~bw,'bridge');
skel_close=bwmorph(skel_bridge,'close');
bw = ~skel_close; clear skel_bridge skel_close

%% Find the medial axis and clean it
skel = bwmorph(~bw, 'thin', Inf);
skel = bwmorph(skel, 'spur', 5);
skel = bwmorph(skel, 'clean', 5);

end
