% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.

function descr = computeDescriptor(fileName)

global option;

%% Load shape
glyphRGB = imread(fileName);

%% Find POINTS (coordinates and orientations)
glyphSkel = gray2skel(glyphRGB); % pre-process input hieroglyph image into thin lines

[y, x] = find(glyphSkel);
t = findSkelOrient(x, y); % compute local orientation field

%% Find PIVOTS
P = findPivots(x, y); % randomely select 400 evenly distributed points along the thin line to be pivot points
X = x(P);
Y = y(P);
T = t(P);

%% Compute descriptors (HOOSC or SC): uncomment
descr = hoosc(X, Y, T, x, y, t);

end
