# Pre-trained models of GaFaR (Geometry-aware Face Reconstruction)
This folder contains GaRaR pre-trained mapping network for whitebox and blackbox attacks against 
ArcFace and ElasticFace models:

- **Whitebox attacks**:
    - `ArcFace-ArcFace_loss.pth`: whitebox attack against ArcFace
    - `ElasticFace-ElasticFace_loss.pth`: whitebox attack against ElasticFace

- **Blackbox attacks**:
    - `ElasticFace-ArcFace_loss.pth`: blackbox attack against ArcFace (using ElasticFace as F_loss)
    - `ArcFace-ElasticFace_loss.pth`: blackbox attack against ElasticFace  (using ArcFace as F_loss)

You can find more information about the dataset (including source code of reconstructing face images) 
on the project page: https://www.idiap.ch/paper/gafar/


## Citation
If you use this method or the provided checkpoints in your work, please cite the following papers:
```bibtex
  @article{tpami2023ti3d,
    author    = {Hatef Otroshi Shahreza and S{\'e}bastien Marcel},
    title     = {Comprehensive Vulnerability Evaluation of Face Recognition Systems to Template Inversion 
                Attacks Via 3D Face Reconstruction},
    journal   = {IEEE Transactions on Pattern Analysis and Machine Intelligence},
    year      = {2023},
    volume    = {45},
    number    = {12},
    pages     = {14248-14265},
    doi       = {10.1109/TPAMI.2023.3312123}
  }

  @inproceedings{iccv2023ti3d,
    author    = {Hatef Otroshi Shahreza and S{\'e}bastien Marcel},
    title     = {Template Inversion Attack against Face Recognition Systems using 3D Face Reconstruction},
    booktitle = {Proceedings of the IEEE/CVF International Conference on Computer Vision (ICCV)},
    pages     = {19662--19672},
    month     = {October},
    year      = {2023}
  }
```