//------------------------------------------------------------------------------
// Tasting families of features for image classification.
// 
// Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
// Written by Charles Dubout <charles.dubout@idiap.ch>
// 
// This file is part of Tasting.
// 
// Tasting is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
// 
// Tasting is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tasting. If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#ifndef ML_INPUTSET_FILEINPUTSET_H
#define ML_INPUTSET_FILEINPUTSET_H

#include "InputSet.h"

#include <iosfwd>
#include <string>
#include <vector>

namespace ML {
	//--------------------------------------------------------------------------
	/// @brief	Creates an input set from files
	//--------------------------------------------------------------------------
	class FileInputSet : public InputSet {
		//_____ Construction / Destruction and Copy _______
	public:
		//----------------------------------------------------------------------
		/// @brief	Constructor
		//----------------------------------------------------------------------
		FileInputSet(const std::string& featuresFileName,
					 const std::string& labelsFileName,
					 const std::string& heuristicsFileName);

		//_____ Methods to implement _______
	protected:
		//----------------------------------------------------------------------
		/// @brief	Creates the first matrix cache
		//----------------------------------------------------------------------
		virtual void matrixCache(std::vector<scalar_t>& data) const;

		//----------------------------------------------------------------------
		/// @brief	Creates the first label cache
		//----------------------------------------------------------------------
		virtual void labelCache(std::vector<unsigned int>& data) const;

		//----------------------------------------------------------------------
		/// @brief	Creates the first weight cache
		//----------------------------------------------------------------------
		virtual void weightCache(std::vector<scalar_t>& data) const;

		//----------------------------------------------------------------------
		/// @brief	Creates the first image cache
		//----------------------------------------------------------------------
		virtual void imageCache(std::vector<unsigned int>& data) const;

		//----------------------------------------------------------------------
		/// @brief	Creates the first coordinates cache
		//----------------------------------------------------------------------
		virtual void coordinatesCache(std::vector<coordinates_t>& data) const;

		//----------------------------------------------------------------------
		/// @brief	Creates the first heuristic cache
		//----------------------------------------------------------------------
		virtual void heuristicCache(std::vector<unsigned int>& data) const;

		//_____ Attributes _______
	private:
		const std::string featuresFileName_;
		std::vector<unsigned int> labels_;
		std::vector<unsigned int> heuristics_;
	};
}

#endif // ML_INPUTSET_FILEINPUTSET_H
