//------------------------------------------------------------------------------
// Tasting families of features for image classification.
// 
// Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
// Written by Charles Dubout <charles.dubout@idiap.ch>
// 
// This file is part of Tasting.
// 
// Tasting is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
// 
// Tasting is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tasting. If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <iterator>
#include <fstream>
#include <string>
#include <vector>
#include <stdint.h>

using namespace std;

// Change to the output folder
#define OUTPUT_FOLDER "./"

// Change to the number of heuristics you want to use
#define NB_HEURISTICS 19

// Change to the names of the heuristics you want to use
const char* HEURISTICS[NB_HEURISTICS] =
{
	"cdubout/fourier_v4",
	"cdubout/gradientblurred",
	"cdubout/haar",
	"cdubout/hog_v6",
	"cdubout/identity",
	"cdubout/segmentation8",
	"examples/identity",
	"examples/mean_threshold",
	"francoisfleuret/average",
	"francoisfleuret/boxedaverages_v3",
	"francoisfleuret/zk_v4",
	"ftarsett/ilbp",
	"ftarsett/lbp",
	"gillesblanchard/blockwise",
	"kanma/grayscalehistogram",
	"kanma/rgbhistogram",
	"leonidas/rgb_hogs",
	"leonidas/dt_hogs_v6",
	"wenqi/hue"
};

void save_mnist_train()
{
	ofstream features(OUTPUT_FOLDER "mnist_train.raw", ios::binary);
	ofstream labels(OUTPUT_FOLDER "mnist_train_labels.txt");
	ofstream heuristics(OUTPUT_FOLDER "mnist_heuristics.txt"); // Same for MNIST test

	const int MNIST_TRAIN[10] = {5923, 6742, 5958, 6131, 5842, 5421, 5918, 6265, 5851, 5949}; // Total = 60000

	for (int i = 0; i < 10; ++i) {
		for (int j = 0; j < MNIST_TRAIN[i]; ++j) {
			for (int k = 0; k < NB_HEURISTICS; ++k) {
				char command[256];
				sprintf(command, "./testheuristic %s ../../mnist/train/%d/%04d.png results.txt", HEURISTICS[k], i, j);

				system(command);

				ifstream results("results.txt");

				for (int l = 0; l < 12; ++l) {
					std::string dummy;
					getline(results, dummy);
				}

				vector<float> data;
				copy(istream_iterator<float>(results), istream_iterator<float>(), back_inserter(data));

				if ((i == 0) && (j == 0))
					heuristics << data.size() << ' ';

				features.write(reinterpret_cast<char*>(&data[0]), data.size() * 4);
			}

			labels << i << ' ';
		}
	}
}

void save_mnist_test()
{
	ofstream features(OUTPUT_FOLDER "mnist_test.raw", ios::binary);
	ofstream labels(OUTPUT_FOLDER "mnist_test_labels.txt");
	// Heuristics are same as for MNIST train

	const int MNIST_TEST[10] = {980, 1135, 1032, 1010, 982, 892, 958, 1028, 974, 1009}; // Total = 10000

	for (int i = 0; i < 10; ++i) {
		for (int j = 0; j < MNIST_TEST[i]; ++j) {
			for (int k = 0; k < NB_HEURISTICS; ++k) {
				char command[256];
				sprintf(command, "./testheuristic %s ../../mnist/test/%d/%04d.png results.txt", HEURISTICS[k], i, j);

				system(command);

				ifstream results("results.txt");

				for (int l = 0; l < 12; ++l) {
					std::string dummy;
					getline(results, dummy);
				}

				vector<float> data;
				copy(istream_iterator<float>(results), istream_iterator<float>(), back_inserter(data));

				features.write(reinterpret_cast<char*>(&data[0]), data.size() * 4);
			}

			labels << i << ' ';
		}
	}
}

int main()
{
	save_mnist_train();
	save_mnist_test();

	// Add code for additional data-set(s) here
}

