
/*
 *  mtp is the ``Multi Tracked Paths'', an implementation of the
 *  k-shortest paths algorithm for multi-target tracking.
 *
 *  Copyright (c) 2012 Idiap Research Institute, http://www.idiap.ch/
 *  Written by Francois Fleuret <francois.fleuret@idiap.ch>
 *
 *  This file is part of mtp.
 *
 *  mtp is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  mtp is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with selector.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MTP_GRAPH_H
#define MTP_GRAPH_H

#include <iostream>
#include <cmath>

using namespace std;

#include "misc.h"
#include "path.h"

class Vertex;
class Edge;

class MTPGraph {
  void update_positivized_lengths();
  void force_positivized_lengths();
  // Set the edge pred_edge_toward_source correspondingly to the path
  // of shortest length. The current implementation is not Dijkstra's!
  void find_shortest_path();
  // Follows the path starting on edge e and returns its length. If
  // nodes is non-null, stores in it the nodes met along the path.
  int retrieve_one_path(Edge *e, Path *path);
  // Returns if the graph is a DAG
  int is_dag();

  Vertex **_front, **_new_front;

  int _nb_vertices, _nb_edges;
  Vertex *_source, *_sink;

  Edge *_edges;
  Vertex *_vertices;

public:

  // These variables are filled when retrieve_disjoint_paths is called
  int nb_paths;
  Path **paths;

  MTPGraph(int nb_vertices, int nb_edges, int *vertex_from, int *vertex_to,
           int source, int sink);

  ~MTPGraph();

  void find_best_paths(scalar_t *lengths);
  void retrieve_disjoint_paths();

  void print(ostream *os);
  void print_dot(ostream *os);
};

#endif
