//------------------------------------------------------------------------------
// Simple example of a heuristic: Identity. The features are a copy of the
// (grayscale) pixels contained in the processed region of interest.
// 
// Copyright (c) 2011 Idiap Research Institute, http://www.idiap.ch/
// Written by Philip Abbet (philip.abbet@idiap.ch)
// 
// This file is part of Heuristics.
// 
// Heuristics is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
// 
// Heuristics is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Heuristics. If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <mash/heuristic.h>

using namespace Mash;


//------------------------------------------------------------------------------
/// The 'Identity' heuristic class
//------------------------------------------------------------------------------
class IdentityHeuristic: public Heuristic
{
    //_____ Construction / Destruction __________
public:
    IdentityHeuristic();
    virtual ~IdentityHeuristic();


    //_____ Implementation of Heuristic __________
public:
    virtual unsigned int dim();

    virtual scalar_t computeFeature(unsigned int feature_index);
};


//------------------------------------------------------------------------------
/// Creation function of the heuristic
//------------------------------------------------------------------------------
extern "C" Heuristic* new_heuristic()
{
    return new IdentityHeuristic();
}



/************************* CONSTRUCTION / DESTRUCTION *************************/

IdentityHeuristic::IdentityHeuristic()
{
}


IdentityHeuristic::~IdentityHeuristic()
{
}


/************************* IMPLEMENTATION OF Heuristic ************************/

unsigned int IdentityHeuristic::dim()
{
    // We have has many features than pixels in the region of interest
    unsigned int roi_size = roi_extent * 2 + 1;
    return roi_size * roi_size;
}


scalar_t IdentityHeuristic::computeFeature(unsigned int feature_index)
{
    // Compute the coordinates of the top-left pixel of the region of interest
    unsigned int x0 = coordinates.x - roi_extent;
    unsigned int y0 = coordinates.y - roi_extent;

    // Compute the coordinates of the pixel corresponding to the feature, in
    // the region of interest
    unsigned int roi_size = roi_extent * 2 + 1;
    unsigned int x = feature_index % roi_size;
    unsigned int y = (feature_index - x) / roi_size;

    // Return the pixel value corresponding to the desired feature
    byte_t** pLines = image->grayLines();
    return (scalar_t) pLines[y0 + y][x0 + x];
}
