
/*
 *  mtp is the ``Multi Tracked Paths'', an implementation of the
 *  k-shortest paths algorithm for multi-target tracking.
 *
 *  Copyright (c) 2012 Idiap Research Institute, http://www.idiap.ch/
 *  Written by Francois Fleuret <francois.fleuret@idiap.ch>
 *
 *  This file is part of mtp.
 *
 *  mtp is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  mtp is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with selector.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <iostream>
#include <fstream>
#include <stdlib.h>

using namespace std;

#include "mtp_tracker.h"

//////////////////////////////////////////////////////////////////////

int main(int argc, char **argv) {
  int nb_locations = 100;
  int nb_time_steps = 1000;

  MTPTracker *tracker = new MTPTracker();

  tracker->allocate(nb_time_steps, nb_locations);

  for(int l = 0; l < nb_locations; l++) {
    for(int m = 0; m < nb_locations; m++) {
      tracker->allowed_motions[l][m] = (drand48() < 0.1);
    }
  }

  for(int t = 0; t < nb_time_steps; t++) {
    for(int l = 0; l < nb_locations; l++) {
      tracker->entrances[t][l] = drand48() < 0.01;
      tracker->exits[t][l] = drand48() < 0.01;
    }
  }

  tracker->build_graph();

  for(int t = 0; t < nb_time_steps; t++) {
    for(int l = 0; l < nb_locations; l++) {
      tracker->detection_scores[t][l] = drand48() - 0.95;
    }
  }

  // Performs the tracking per se

  tracker->track();

  // Prints the detected trajectories

  for(int t = 0; t < tracker->nb_trajectories(); t++) {
    cout << "Trajectory "
         << t
         << " starting at " << tracker->trajectory_entrance_time(t)
         << ", duration " << tracker->trajectory_duration(t)
         << ", score " << tracker->trajectory_score(t)
         << ", through nodes ";
    for(int u = 0; u < tracker->trajectory_duration(t); u++) {
      cout << " " << tracker->trajectory_location(t, u);
    }
    cout << endl;
  }

  delete tracker;

  exit(EXIT_SUCCESS);
}
