// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "int_real.h"

namespace Torch {

extern "C" int compar_int_real(const void *p1, const void *p2)
{
  Int_real v1 = *((Int_real*)p1);
  Int_real v2 = *((Int_real*)p2);
  if (v1.the_real > v2.the_real)
    return 1;
  if (v1.the_real < v2.the_real)
    return -1;
  return 0;
}

extern "C" int compar_real(const void *p1, const void *p2)
{
	real v1 = *((real*)p1);
	real v2 = *((real*)p2);
  if (v1 > v2)
    return 1;
  if (v1 < v2)
    return -1;
  return 0;
}

extern "C" int compar_real_real(const void *p1, const void *p2)
{
  real_real v1 = *((real_real*)p1);
  real_real v2 = *((real_real*)p2);
  if (v1.real1 > v2.real1)
    return 1;
  if (v1.real1 < v2.real1)
    return -1;
  return 0;
}

extern "C" int compar_int_char(const void *p1, const void *p2)
{
  Int_char v1 = *((Int_char*)p1);
  Int_char v2 = *((Int_char*)p2);
  return (strcmp(v1.the_char, v2.the_char));
}

}

