// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PASparseSupportSetLK.h"

namespace Torch {

PASparseSupportSetLK::PASparseSupportSetLK(int d)
: PASparseSupportSet(d)
{
	size = 1;
	alpha_set = (real*) sv_allocator->alloc(sizeof(real));	
	alpha_set[0] = 1.0;
	// sv = non-sparse zero vector
	sv_set = (svector*) sv_allocator->alloc(sizeof(svector));
	sv_set[0].size = d;
	sv_set[0].frame = (sreal*) sv_allocator->alloc(sizeof(sreal) * d);
	for (int i = 0; i < d; i++)
	{
		sv_set[0].frame[i].index = i;
		sv_set[0].frame[i].value = 0.0;
	}
}

void PASparseSupportSetLK::add(real alpha, svector *vector)
{
	// explicit addition since the kernel is LINEAR
	sreal *cur_frame = vector->frame;
	sreal *last_frame = vector->frame + vector->size;
 
	while (cur_frame != last_frame)
	{
		int index = cur_frame->index;
		sv_set[0].frame[index].value += alpha * cur_frame->value;
		cur_frame++;
	}
}

void PASparseSupportSetLK::empty()
{
	for (int i = 0; i < sv_set[0].size; i++)
		sv_set[0].frame[i].value = 0.0;
}

PASparseSupportSetLK::~PASparseSupportSetLK() {}

}
