// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PASparseDataset.h"
#include "Random.h"

namespace Torch {

PASparseDataset::PASparseDataset(SparseMatrix *m_)
{
	m = m_;
	n_examples = m->nl;
	shuffle = (int*) allocator->alloc(sizeof(int) * n_examples);
	cur_index = 0;
}

void PASparseDataset::init()
{
	cur_index = 0;
	Random::getShuffledIndices(shuffle, n_examples);
  // empty stack
  while (example_stack->n_stacked_objects > 0)
	  popExample();
  // free current_example
  allocator->free(current_example);
  current_example=NULL;	
}

PAExample *PASparseDataset::nextExample()
{
	getExample(shuffle[cur_index]);
	cur_index = (cur_index + 1) % n_examples;
	return current_example;
}

PAExample *PASparseDataset::getExample(int i)
{
  // current example allocated ?
  if (!current_example)
    current_example = new(allocator) PASparseExample(m->nc);
  // copy the right matrix line
  ((PASparseExample*)current_example)->vector = m->lines + i;
  // return value
  return current_example;
}

int PASparseDataset::getNExamples()
{
  return n_examples;
}


PASparseDataset::~PASparseDataset()
{}

}
