// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PAIndexDataset.h"
#include "Random.h"

namespace Torch {

// Example
PAIndexExample::PAIndexExample()
{
	set_index = -1;
	example_index = -1;
}	

void PAIndexExample::set(int set_index_, int example_index_)
{
  set_index = set_index_;
  example_index = example_index_;	
}

PAIndexExample::~PAIndexExample()
{}

// Set of Examples
PAIndexDataset::PAIndexDataset(int set_index_, int n_examples_)
{
	set_index = set_index_;
	n_examples = n_examples_;

  shuffle = (int*) allocator->alloc(sizeof(int) * n_examples);
	cur_index = 0;
}

void PAIndexDataset::init()
{
  cur_index = 0;
  Random::getShuffledIndices(shuffle, n_examples);
  // empty stack
  while (example_stack->n_stacked_objects > 0)
    popExample();
  // free current_example
  allocator->free(current_example);
  current_example=NULL;
}

PAExample *PAIndexDataset::nextExample()
{
  getExample(shuffle[cur_index]);
  cur_index = (cur_index + 1) % n_examples;
  return current_example;
}

PAExample *PAIndexDataset::getExample(int i)
{
  // current example allocated ?
  if (!current_example)
    current_example = new(allocator) PAIndexExample();
  // put correct indexes
  ((PAIndexExample*)current_example)->set(set_index, i);
  // return value
  return current_example;
}

int PAIndexDataset::getNExamples()
{
	return n_examples;
}

PAIndexDataset::~PAIndexDataset()
{}

}
