// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PACachedKernel.h"

namespace Torch {

PACachedKernel::PACachedKernel()
{
	n_matrices = 0;
	indexes = NULL;
	matrices = NULL;
	transposed = NULL;
}

void PACachedKernel::addMatrix(int set_a, int set_b, Sequence *ab)
{
	n_matrices++;
	// transposed
	transposed = (bool*) allocator->realloc(transposed, sizeof(bool*) * n_matrices);
	transposed[n_matrices - 1] = (set_b < set_a);
	// indexes
	indexes = (int**) allocator->realloc(indexes, sizeof(int*) * n_matrices);
	indexes[n_matrices - 1] = (int*) allocator->alloc(sizeof(int) * 2);
	indexes[n_matrices - 1][0] = (set_a <= set_b) ? set_a : set_b; // first index is always the smallest
  indexes[n_matrices - 1][1] = (set_a <= set_b) ? set_b : set_a;
	// matrices
	matrices = (Sequence**) allocator->realloc(matrices, sizeof(Sequence*) * n_matrices);
	matrices[n_matrices - 1] = ab;
}

real PACachedKernel::forward(PAExample *x, PAExample *y)
{
	return forward((PAIndexExample*) x, (PAIndexExample*) y);
}

real PACachedKernel::forward(PAIndexExample *x, PAIndexExample *y)
{
	if (x->set_index > y->set_index) 
		return forward(y, x);
	else
	{
	 // search for the correct matrix
		int i = 0;
		while (  (i < n_matrices)
					 &&((x->set_index != indexes[i][0])||(y->set_index != indexes[i][1])))
					{i++;}
		// found ?
		if (i == n_matrices)
			error("Requested kernel value not in any matrix");
		// return requested cached value
		if (transposed[i])	
			return matrices[i]->frames[y->example_index][x->example_index];
		else
			return matrices[i]->frames[x->example_index][y->example_index];
	}	
}

PACachedKernel::~PACachedKernel()
{}

}
