// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef ImgRtrvMeasurerRanking_INC
#define ImgRtrvMeasurerRanking_INC

#include "PAMeasurer.h"
#include "SparseMatrix.h"
#include "PADataset.h"
#include "PAMachine.h"
#include "XFile.h"

namespace Torch
{

class ImgRtrvMeasurerRanking : public PAMeasurer
{
  public:
	// per query results or average over query set ?
	bool averaging;
	// data
	int n_best;
	int n_que;
	int n_img;
	SparseMatrix *queries;
	PADataset *images;
	// machine to evaluate
	PAMachine *machine;
	// to make retrieval measurements
	sreal *ranking;
	real *cur_que_scores;
	// output
	XFile *out;	

  ImgRtrvMeasurerRanking(PAMachine *machine_, SparseMatrix *queries_, 
									PADataset *images_, int n_best_, XFile *out_);
	 
	virtual void measure();

	void measureQuery(svector *query);		
	virtual void getQueryScores(svector *query);

	virtual ~ImgRtrvMeasurerRanking();
};

}
#endif
