// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "ImgRtrvMeasurerRanking.h"
#include "ImgConstraint.h"

namespace Torch {

ImgRtrvMeasurerRanking::ImgRtrvMeasurerRanking
 (PAMachine *machine_, SparseMatrix *queries_, 
	PADataset *images_, int n_best_,
  XFile *out_)
{
  machine = machine_;
  queries = queries_;
  images = images_;
  n_best = n_best_;
	out = out_;

  n_que = queries_->nl;
  n_img = images->getNExamples();

	ranking = (sreal*) allocator->alloc(sizeof(sreal) * n_best);
	cur_que_scores = (real*) allocator->alloc(sizeof(real) * n_img);
} 


void ImgRtrvMeasurerRanking::measure()
{
	for (int q = 0; q < n_que; q++)
	{
		measureQuery(queries->lines + q);
		for (int i = 0; i < n_best; i++)
			out->printf("%d ", ranking[i].index);
		out->printf("\n");
	}
}

void ImgRtrvMeasurerRanking::measureQuery(svector *query)
{
	// get the RSV for each image
	getQueryScores(query);
	// initialize ranking 
	for (int i = 0; i < n_best; i++)
	{
		ranking[i].index = -1;
		ranking[i].value = -INF;
	}
	// find n-best 
	for (int i = 0; i < n_img; i++)
	{
		// n-best bubble sort 
		real the_score = cur_que_scores[i];	
		int j = n_best;
		while ((j > 0)&&(ranking[j-1].value < the_score))
			j--;
    int n_to_move = n_best - j - 1;
		if (n_to_move >= 0)
		{
			if (n_to_move > 0)	 
				memmove(ranking + (j + 1), ranking + j, sizeof(sreal) * n_to_move);
			ranking[j].index = i;
			ranking[j].value = the_score;
		}
	}
}

void ImgRtrvMeasurerRanking::getQueryScores(svector *query)
{
  // get the RSV for each image
  ImgConstraint *x = new (allocator) ImgConstraint();
  for (int i = 0; i < n_img; i++)
  {
    PAExample *img = images->getExample(i);
    x->set(query, img, NULL, 0);
    cur_que_scores[i] = machine->forward(x);
  }
  allocator->free(x);
}

ImgRtrvMeasurerRanking::~ImgRtrvMeasurerRanking()
{}

}
