// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "ImgLoss.h"

namespace Torch{

ImgLoss::ImgLoss(real C_):PALoss(C_)
{}

real ImgLoss::getLoss(PAMachine *m, PAExample *x)
{
	return getLoss(m, (ImgConstraint*) x);
}

real ImgLoss::getLoss(PAMachine *m, ImgConstraint *x)
{
	real res = x->epsilon - m->forward(x); 
	if (res < 0) res = 0;
	return res;
} 

void ImgLoss::getSupport(PAMachine *m, PAExample *x, real l)
{
	getSupport(m, (ImgConstraint*) x, l);
}

void ImgLoss::getSupport(PAMachine *m, ImgConstraint *x, real l)
{
	sv = x;
	alpha = 0;
	if (l > 0)
	{
		real local_c = C * x->weight;
		alpha = l / m->squareNorm(x);
		if (alpha > local_c) alpha = local_c;
	}
}

ImgLoss::~ImgLoss()
{}

}
