// ************************************************************************************
// try_fopen.cc
//
// version
// *************************************************************************************




#ifndef TRY_FOPEN_CC
#define TRY_FOPEN_CC



#include <stdio.h>				// for fopen()
#include <stdlib.h>				// for exit()
#include <ctype.h>				// for isdigit()
#include <string.h>				// for strcmp(), strlen()

#include "StringClass.h"			// for strings
#include "try_fopen.h"


/* VERSION NORMALE, sans insertion de 0 pour la numrotation

// ***************************************************************************
// OUVERTURE D'UN FICHIER + TEST SI OK (+ SORTIE EVENTUELLE)

FILE *try_fopen
	(char *nom_f,
	 char *mode
	)
{
 // CAS DES E/S STANDARDS
 // =====================
 if( strcmp("stdout",nom_f)==0 )	return(stdout);
 if( strcmp("stdin", nom_f)==0 )	return(stdin);
 if( strcmp("stderr",nom_f)==0 )	return(stderr);


 // CAS GENERAL
 // ===========
 FILE *f;
 char texte[16];

 if( (f = fopen(nom_f,mode))==NULL)
   	{switch(mode[0])
	  {case 'r'	: sprintf(texte,"de lire");	break;
	   case 'w'	: sprintf(texte,"d'ecrire");	break;
	   default	:  sprintf(texte,"d'ouvrir");
	  }

	 fprintf(stderr,"Abandon: Impossible %s %s\n",texte,nom_f);
    	 exit(-1);
	 return(f);				// juste pour que le compilo gobe !
   	}
 else	return(f);
}

*/

// ***************************************************************************
// ECRITURE DANS UN FICHIER + TEST SI OK (+ SORTIE EVENTUELLE)

int try_fwrite
	(char *ptr,
	 int  taille_elt,
	 int  nb_elts,
	 FILE *f,
	 char *nom_f			// optionnel = "le fichier" par defaut
	)

{if( nb_elts != (int)fwrite(ptr,taille_elt,nb_elts,f) )
  {fprintf(stderr,"Abandon: Impossible d'ecrire entierement %s\n",nom_f);   exit(-1);}

 return(nb_elts);
}



// ***************************************************************************
// LECTURE DANS UN FICHIER + TEST SI OK (+ SORTIE EVENTUELLE)

int try_fread
	(char *ptr,
	 int  taille_elt,
	 int  nb_elts,
	 FILE *f,
	 char *nom_f			// optionnel = "le fichier" par defaut
	)

{
  int ret=(int)fread(ptr,taille_elt,nb_elts,f);
  //  int ret;
  // int i,j;
  /*
  i=0; ret=1;
  while(ret==1 && i< nb_elts){
    j=0;
    while(ret==1 && j< taille_elt){
      ret=(int)fread(&ptr[i*taille_elt+j],1,1,f);
      if(ret==1) j++;
    }
    if(ret==1) i++;
  }

  if(i!=nb_elts || ret!=1){
    printf("ret=%d  %d  %d\n",ret,i,j);
    printf("%d %d %d\n",(unsigned char)ptr[i],(unsigned char)ptr[i+1],(unsigned char)ptr[i+2]);

}
  */  

  if( nb_elts != ret )
    {
      fprintf(stderr,"Warning: Impossible de lire entierement %s\n",nom_f);
      fprintf(stderr,"%d elements read and %d expected\n",ret,nb_elts); 
      //exit(-1);
    }

  return(ret);

}





// ***************************************************************************
// version avec recherche par insertion ventuelle de 0 dans la numrotation
// ***************************************************************************

// FONCTION UTILITAIRE LOCALE

static int index_debut_dernier_nombre(char * s)	// si erreur, rsultat ngatif
{
 int i = strlen(s)-1;

 // REMONTE JUSQU'AU DERNIER NOMBRE
 // ===============================
 while( i>=0 && !isdigit(s[i]) )	i--;
 if(i<0)	return(-1);

 // REMONTE AU DEBUT DE CE NOMBRE
 // =============================
 while( i>=0 && isdigit(s[i]) )		i--;
 return(i+1);					// index du 1er chiffre du nombre
}




// ESSAI D'OUVERTURE (avec insertion eventuelle de 0)
// si echoue, stoppe par exit(),
// sinon retourne handler et "vrai" nom d'ouverture


FILE *try_fopen
	(char *nom_f,
	 char *mode,
	 chaine& vrai_nom_f,
	 int  sortie			// exit() si erreur. Optionnel, VRAI par defaut
	)
{vrai_nom_f = chaine(nom_f);		// nom_f considr a priori exact


 // CAS DES E/S STANDARDS
 // =====================
 if( strcmp("stdout",nom_f)==0 )	return(stdout);
 if( strcmp("stdin", nom_f)==0 )	return(stdin);
 if( strcmp("stderr",nom_f)==0 )	return(stderr);


 // CAS GENERAL
 // ===========
 FILE *f;

 if( (f = fopen(nom_f,mode))!=NULL )	return(f);


 // SINON ON TENTE D'INSERER DES 0 (ventuelle numrotation de squence)
 // ====================================================================
 int i;

 if( (i=index_debut_dernier_nombre(nom_f)) >=0 )
  {chaine fin( nom_f+i );			// toute la fin de nom_f
   chaine debut = chaine(nom_f)-fin;		// tout le debut de nom_f

   for(i=1;  i<=10;  i++)
	  {debut = debut + 0;				// on insere un zero de plus
     vrai_nom_f = debut + fin;
     if( (f = fopen((char *)vrai_nom_f,mode))!=NULL ){
		 printf("Opening File %s\n",(char *)vrai_nom_f);
		 return(f);
	  }
	  
    }
  }


 // LA RECHERCHE A ECHOUEE
 // ======================
 char	texte[128];

 switch(mode[0])
    	  {case 'r'	: sprintf(texte,"de lire");	break;
   	   case 'w'	: sprintf(texte,"d'ecrire");	break;
	   default	: sprintf(texte,"d'ouvrir");
	  }

 if(sortie)
	{fprintf(stderr,"Abandon: Impossible %s %s\n",texte,(char *)nom_f);
 	 exit(-1);
	}
 return(f);

}




FILE *try_fopen
	(char *nom_f,
	 char *mode
	)
{chaine(bidon);
 return( try_fopen(nom_f,mode,bidon) );
}


// ***************************************************************************
// FERMETURE D'UN FICHIER + (SAUF SI ON AVAIT OUVERT UNE E/S STANDARD)

void try_fclose(FILE *f)
{ if( f!=stdin && f!=stdout && f!=stderr )
	fclose(f);
}


	
#endif // TRY_FOPEN_CC
