#ifndef IPCV_HISTOGRAM_MEASURER_INC
#define IPCV_HISTOGRAM_MEASURER_INC

#include "general.h"
#include "Vec.h"
#include "Mat.h"

// open cv
#include "cv.h"
#include "cvtypes.h"

#include "ipcv_MultiImage.h"
#include "ipcv_HistogramTemplate.h"
#include "ip_BoundingBox.h"

namespace ImageProcessing {


  class ipcv_HistogramMeasurer {

  public:

    ipcv_HistogramMeasurer() {};

    // compute a normalized histogram (to 1)
    // should we add a function or a member to tell
    // whether we want the histogram to be normalized or not ?

    // return value : whether the histogram computation is valide
    // (eg. if the object fall outside image range, or the number of
    //  points is too small)

    // Histogram characterized by (nb bands) and (nb dimensions) taken 
    // from the histogram template characteristics
    // The BBoxes are the locations (a box) associated with each of 
    // the dimensions of the histogram
    // (one per dimension here)

    virtual bool  computeHistogram(IplImage               **bands,
				   ipcv_HistogramTemplate *H,
				   ip_BoundingBox         *BBoxes,
				   bool                   Normalize=true);
    
    virtual ~ipcv_HistogramMeasurer() {};

  };


}

#endif // IPCV_HISTOGRAM_MEASURER_INC
