#include "ip_PlanarTranslationScaling.h"

namespace ImageProcessing  {
  
  /** 
      Basic representation for 2D Translation + isotropic scaling.
      
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
      xp = Tx + s * dx
      yp = Ty + s * dy

      image_point    = (xp,yp)
      initial_point  = (x,y)
      dx = x - origin.x
      dy = y - origin.y

      Tx = params[0];
      Ty = params[1];
      s  = params[2];  

      Reminder : x axis = column axis , y axis = line axis
  */

  //============================================================

  //-------- 
  ip_PlanarTranslationScaling::ip_PlanarTranslationScaling(){
    m_iNbParams=3;
    m_pParams=new real [m_iNbParams];
    m_pTx=&m_pParams[0]; m_pTy=&m_pParams[1];
    m_pScale=&m_pParams[2];
  }

  //-------- 
  ip_PlanarTranslationScaling::ip_PlanarTranslationScaling(real *_params){
    m_iNbParams=3;
    m_pParams=new real [m_iNbParams];
    m_pTx=&m_pParams[0]; m_pTy=&m_pParams[1];
    m_pScale=&m_pParams[2];
    setParams(_params);
  }

  //-------- 
  ip_PlanarTransformModel  ip_PlanarTranslationScaling::planarModel(){
    return PLANAR_TRANSLATION_SCALING; }

  //------------------------- 
  //- init to the null motion (identity transform)
  void  ip_PlanarTranslationScaling::setIdentity(){
    *m_pTx=m_cOrigin.m_rX; *m_pTy=m_cOrigin.m_rY; *m_pScale=1.;
  }

  //--------
  void  ip_PlanarTranslationScaling::changeOrigin(ip_Point new_origin){
    ip_Point p;
    p=imagePoint(new_origin);
    m_pParams[0]=p.m_rX; m_pParams[1]=p.m_rY;
    m_cOrigin=new_origin;
  }
  
  //-------
  void ip_PlanarTranslationScaling::display(char * msg){
    printf("\n Translation : Tx(col) = %6.2f   Ty(line) = %6.2f Isotropic Scaling : S = %6.2f \n",
	   m_pParams[0],m_pParams[1],m_pParams[2]);
  }
  
  //-------
  ip_PlanarTranslationScaling::~ip_PlanarTranslationScaling() {
    delete [] m_pParams;
  }

}

