#ifndef IP_PIXEL_AND_POINT_HH
#define IP_PIXEL_AND_POINT_HH


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

#include "general.h" // for the definition of real

namespace ImageProcessing  {

 /** 
     Basic class for representing pixels (integers) and 
     2d point.      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  
  /*
       ip_Pixel   = two members :   li,co
       ip_Point   = two members :   x,y 

       ATTENTION : x corresponds to the column direction !

       Initialisation is performed by providing fisrt x axis (x or co)
       the y axis (y or li)

   */

  //============================================================
#define ip_DiscreteVector  ip_Pixel
#define ip_PixelNil        ip_Pixel(-20000,-20000)

  class ip_Pixel
    {
    public:
      int m_iCo;
      int m_iLi;

      //-----------
      ip_Pixel(int vco=0,int vli=0){ m_iCo=vco; m_iLi=vli; }

      //-----------
      inline ip_Pixel &	operator+=(ip_DiscreteVector v)
      { m_iLi+=v.m_iLi; m_iCo+=v.m_iCo;   return *this; }

      inline ip_Pixel&	operator-=(ip_DiscreteVector v)
      { m_iLi-=v.m_iLi; m_iCo-=v.m_iCo;   return *this; }
      
      //-----------
      void display(char *com=""){ printf("Pixel %s (%3d,%3d) \n",com,m_iLi,m_iCo); }
      //-----------
      //-----------
      //-----------

    };

  //============================================================

#define  ip_Vector  ip_Point

  class  ip_Point
    {
    public: 
      real m_rX;    // correspond to the column axis
      real m_rY;


      //-----------
      ip_Point(real vX=0,real vY=0){ m_rX=vX; m_rY=vY; }

      //-----------
      ip_Point(int vco,int vli){ m_rX=(real)vco; m_rY=(real)vli; }

      //-----------
      ip_Point(ip_Pixel p){ m_rX=(real)p.m_iCo; m_rY=(real)p.m_iLi; }

      //-----------
      inline ip_Point &	operator+=(ip_Vector v)
      { m_rY+=v.m_rY; m_rX+=v.m_rX;   return *this; }

      inline ip_Point &	operator-=(ip_Vector v)
      { m_rY-=v.m_rY; m_rX-=v.m_rX;   return *this; }
      
      //-----------
      void display(char *com=""){ printf("Point %s (y=%5.2f,x=%35.2f) \n",com,m_rY,m_rX); }

      //-----
      void init(real x, real y) {m_rX=x; m_rY=y;}

      //-----
      ~ip_Point(){}

     
    };

} 

#endif  // IP_PIXEL_AND_POINT
