#include "general.h"
#include "StringClass.h"
#include "ip_ImageName.h"
#include <ctype.h>

namespace ImageProcessing {

  //-----
  
  /** 
   
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  //-----------
  ip_ImageName::ip_ImageName(int _TypeNumber, int _NbDigits){ 
    m_iTypeNumber=_TypeNumber;  
    m_iNbDigits= _NbDigits;
    m_iNumber=-1;
  };
  
  //-----------
  ip_ImageName::ip_ImageName(char * OneName,int _TypeNumber, int _NbDigits){
    chaine one(OneName);
    int l,d;

    m_iTypeNumber=_TypeNumber;  
    m_iNbDigits= _NbDigits;

    m_cExtension=suffixe_ch(one);
    m_tType=ImType(m_cExtension);
    l=longueur_ch(one)-longueur_ch(m_cExtension);
    one=debut_ch(one,l);
    d=l;
    while(d>0 && isdigit(one.s[d-1]))
      d--;

    if(m_iTypeNumber==FixedLength && m_iNbDigits== -1)
      m_iNbDigits=l-d;
    
    m_iNumber=valeur_ch(milieu_ch(one,d,l-1));

    if(d==l)
      m_iNumber=-1;

    // looking for directory
    l=d-1;
    while(d>0 && one.s[d-1] !='/')
      d--;
    m_cBaseName=milieu_ch(one,d,l);
    if(d==0){
	  m_cDirectory=chaine("./");
    }
    else
      m_cDirectory=debut_ch(one,d);
  }
  
  //-----------
  ip_ImageName::ip_ImageName(chaine &dir, chaine &base, chaine & ext,int number,
			     ip_ImageType type,int _TypeNumber, int _NbDigits) : 
    m_cDirectory(dir), m_cBaseName(base),
    m_cExtension(ext),m_iNumber(number),m_tType(type) {
    m_iTypeNumber=_TypeNumber;  
    m_iNbDigits= _NbDigits;  
  }

  //-----------
  char * ip_ImageName::fullName(){
    m_cFullName=m_cDirectory+m_cBaseName+number()+m_cExtension;
    return (char *)m_cFullName.s;
  }
  
  //-----------
  chaine ip_ImageName::number(){
    chaine c("");

    if(m_iNumber>=0){
      c=c+m_iNumber;
      
      switch(m_iTypeNumber){
      case FixedLength:
		  {
			 int l=longueur_ch(c);
			 if(m_iNbDigits-l>0){
				chaine c0(m_iNbDigits-l);
				int i;
				for(i=0;i<m_iNbDigits-l;i++)
				  c0[i]='0';
				c0[m_iNbDigits-l]='\0';
				fflush(stdout);
			 
				return c0+c;
			 }
			 else
				return c;
		  }
		  break;
      case Standart:
      default:
		  return c;
		  break;
      }
    }
    else {
      c=chaine("");
      return c;
    }

  }

  //-----------
  void ip_ImageName::display(FILE *f){
    fprintf(f,"Dir = >%s<   Name = >%s<  Number = >%d< Extension = >%s< Type = >%d<\n",
	    m_cDirectory.s,m_cBaseName.s,m_iNumber,m_cExtension.s,m_tType);
  }

  //-----------
  ip_ImageName::~ip_ImageName(){};
  

}
