/* 
------------------------------------------------------------------------
_Institution : IDIAP
------------------------------------------------------------------------
_Module_Name : 

_Description : 

_Call :        

_System  : Unix
_Remarks : None

_Author : Jean-Marc Odobez
_Revisions History:


------------------------------------------------------------------------
_end
*/

#include "MyLoadSaveImageT.h"

namespace ImageProcessing {

// ***************************************************************************
//  Entete + code, par octet, en ASCII (P3) ou binaire (P6)
//  
//  
void charge_pnm(Tab<ip_ColorElement8u> & MonImage, char* nom,int debug)
{
  chaine VraiNom;
  
 FILE* f = try_fopen(nom,"rb",VraiNom);
 int  ti,tj;
 int  size,good_size,EstP3;
 char c, marque[2+1];				// 2 carac. + 0 terminal



 // LECTURE DE L'ENTETE PPM
 // =======================
 fscanf(f,"%2s\x0A%c", marque,&c);		// absorbe P6+'CR' et lit car. suivant
 if( marque[0]!='P' || (marque[1]!='6' && marque[1]!='3'))
	{cerr<<"Abandon: Pas d'entete PPM dans "<<nom<<endl;    exit(-1);}

 if(marque[1]=='3') { EstP3=1; }
 else { EstP3=0; }


 // ABSORBE LES n LIGNES DE COMMENTAIRE (CONSECUTIVES)
 // ==================================================
 while( c=='#' )
   {fscanf(f,"%*[^\x0A]\x0A%c",&c); 		// absorbe commentaire ($0A inclus)
   }
 fseek(f,-1L,SEEK_CUR);				// recule pour se remettre sur c


 // LECTURE DES INFOS IMAGE
 // =======================
 fscanf(f,"%d %d",&tj,&ti);			// lecture des infos-image
 good_size =255;
 // fscanf(f,"%d\x0A",&size);		// PPM normal (8 bits): niveau gris max
 fscanf(f,"%d",&size);
 c=(char)getc(f);
 char ccr='\x0A';
 while(c!=ccr && c!='\n')
   c=(char)getc(f);
  

#ifdef Msg_ES
 if(debug>0){
	cout<<"Lecture de "<<nom<<" ... ("<<ti<<" x "<<tj<<")"<<endl;
 }
#endif

 if( MonImage.dim1!=ti || MonImage.dim2!=tj )
	{
	 MonImage.libere_partie_dyn();
     	 MonImage.alloue_partie_dyn(0,ti-1,0,tj-1);
	}


 // LECTURE DES PIXELS
 // ==================
 if(EstP3==1){
   int li,co,r,g,b;
   for(li=0;li<MonImage.dim1;li++)
     for(co=0;co<MonImage.dim2;co++){
       fscanf(f,"%d",&r); fscanf(f,"%d",&g); fscanf(f,"%d",&b);
       MonImage(li,co).r=(unsigned char)r;
       MonImage(li,co).g=(unsigned char)g;
       MonImage(li,co).b=(unsigned char)b;
     }
 }
 else {
   try_fread( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),
	      sizeof(ip_ColorElement8u),MonImage.dim1*MonImage.dim2,f,nom);
 
 }
 fclose(f);
}


  // ***************************************************************************
  //
  // Sauvegarde d'une image couleur : defaut format binaire pnm
  //
  void sauve_pnm(Tab<ip_ColorElement8u> & MonImage,
		 char *nom,
		 int  P3, // defaut = pnm
		 int debug	  ,
		 //	 char *ext = "",
		 char *commentaire ,
	       char *commentaire2,
		 char *commentaire3
		 )
  {
    FILE* f;
  
    f = try_fopen(nom,"w");
#ifdef Msg_ES
    if(debug>0){
      cout<<"Ecriture de "<<nom<<" ...";
      fflush(stdout);
    }
#endif
  
    
  
    // ECRITURE DE L'ENTETE PGM
    // =========================
    if(P3==0){
      fprintf(f,"P6\x0A");
    }
    else {
      // marque PGM
      fprintf(f,"P3\x0A");
    }
    
    // ecrit lignes de commentaire non-vides
    if( commentaire[0] !='\0' )	fprintf(f,"# %s\x0A",commentaire);
  if( commentaire2[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire2);
  if( commentaire3[0]!='\0' )	fprintf(f,"# %s\x0A",commentaire3);
  
  fprintf(f,"%d %d\x0A", MonImage.dim2, MonImage.dim1);			// dimensions
  fprintf(f,"%d\x0A",255);				// niveau de gris maximum
  
  // ECRITURE DES ELEMENTS
  // =====================
  if(P3==0){
    try_fwrite( (char*)&(MonImage.ptr2[MonImage.inf1][MonImage.inf2]),
		sizeof(ip_ColorElement8u),MonImage.dim1*MonImage.dim2,f,nom);
  }
  else {
    int li,co;
    for(li=0;li<MonImage.dim1;li++)
      for(co=0;co<MonImage.dim2;co++){
	fprintf(f," %3d %3d %3d",
	       MonImage(li,co).r,MonImage(li,co).g,MonImage(li,co).b);
      }
    fprintf(f,"\n");
  }
  
#ifdef Msg_ES
  if(debug>0){
    cout<<"  terminee."<<endl;
    fflush(stdout);
  }
#endif
  
  fclose(f);
  }
  

} // namespace....
