/******************************************************************************
*
*
*
*
******************************************************************************/

#include <stdio.h>
#include "cv.h"        /* Basic OpenCV header file. */
#include "ipl.h"


#include "bicv_HistogramLikelihood.h"
#include "bicv_BoundingBoxesTemplate.h"
#include "bicv_BoundingBoxesSetTemplate.h"
#include "bf_DistributionReal.h"
#include "bf_ExponentialDistribution.h"

#include "bicv_HistogramTracker.h"

#include "ipcv_HistogramTemplate.h"
#include "ip_BoundingBox.h"

#include "ip_PlanarTranslationScaling2.h"
#include "ip_PlanarTranslationScaling.h"
#include "ip_PlanarTranslation.h"

#include "tab.h"
#include "ipcv_MultiImage.h"
#include "ip_LoadSaveImage.h"
#include "ipcv_SeqImageFile.h"

#include "bicv_IplImagesDataRV.h"


#include "CmdLine.h"


using namespace Torch;
using namespace ImageProcessing;

//================================================================
class MyCmdLine {
  
public:
  // define all parameters there
  CmdLine cmd;

  // parameters to put "in" the command line.
  char      *ImageDirectory;
  char      *ImageName;
  int       First;
  int       Last;
  int       Step;


  int       TransformType;

  int       data_kind;       // 1 = HSV, 0 = RGB
  int       number_of_bands; // from the choosen data, which number of band to consider
  int       nbsamples;
  int       splitwidth,splitheight,numberofbin;

  int       botrightco,botrightli,upleftco,upleftli;

  // Dynamics related
  real      TranslationStdDev;
  real      AffineStdDev;

  // Likelihood related
  real      LambdaH;     // lambda coefficient in the exponential
  real      ZpartitionH; // partition constant

  // Display and output
  
  // display individuals whose weight satisfay w/wmax>ratio_minimum_weight
  int     display_individuals; // 1 : particle display with sufficient weight
  float   ratio_minimum_weight;
  
  bool SurroundOnly;
  int  Thickness;
  bool DisplayModeShape;
  int  ThicknessOfMode;
  
  int SavingFrequency; // frequency of saving result image


  MyCmdLine (){

    // real d=14.34;
    real sigma=0.16;
    real l=1./(2.*sigma*sigma);
    //  real Z=1e9*exp(d*log(sigma));
    real Z=1.;


    // Prepare the command line
    cmd.info("Tracking a square region based on color histograms and particle filter");
    cmd.addText("\nArguments:");

    cmd.addSCmdArg("OneImageName",&ImageName," Name of one of the image in the sequence");
    cmd.addICmdArg("First",&First," number of the first image to process");
    cmd.addICmdArg("Last",&Last," number of the last image to process");

    cmd.addText("\nGeneral options:");
    
    cmd.addICmdOption("-step", &Step,1," step between two image number");
    cmd.addSCmdOption("-imagedir", &ImageDirectory,""," directory of the input images");

    cmd.addText("\nParticle Filter options:");

    cmd.addICmdOption("-nbsamples", &nbsamples,500," number of particle samples");
    cmd.addICmdOption("-transform", &TransformType,1," transformation to track : \n\t\t\t\t 1(translation+scale) 2(trans+scalex+scaley) others (translation)");

    cmd.addText("\nHistogram likelihood options:");
    cmd.addICmdOption("-colormodel", &data_kind,1," color model (1 = HSV, 0 = RGB)");
    cmd.addICmdOption("-colormodel", &number_of_bands,3," number of bands to keep (for histograming) \n\t\t\t\t in the chosen model");
    cmd.addICmdOption("-nbbin", &numberofbin,8," number of bins in the histogram");
    cmd.addRCmdOption("-lambdah", &LambdaH,l," lambda coefficient in exponential distribution");
    cmd.addRCmdOption("-partitionh", &ZpartitionH,Z," partition function of the exponential distribution");
   

    cmd.addText("\nInitial box options:");
    cmd.addICmdOption("-botrightco", &botrightco,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-botrightli", &botrightli,-1," line number of bottom right initial box corner");
    cmd.addICmdOption("-upleftco", &upleftco,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-upleftli", &upleftli,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-splitheight", &splitheight,1," number of box split of the height");
    cmd.addICmdOption("-splitwidth", &splitwidth,1," number of box split of the width");

    cmd.addText("\nDynamics options:");
    cmd.addRCmdOption("-trans_std", &TranslationStdDev,2.," noise standart deviation (translation components)");
    cmd.addRCmdOption("-affine_std", &AffineStdDev,0.01," noise standart deviation (affine components)");

    cmd.addText("\nOuput options :");
    cmd.addICmdOption("-individuals",&display_individuals,1," draw(1) or not (0) samples with sufficiently high likelihood weight");
    cmd.addRCmdOption("-ratioweight", &ratio_minimum_weight,0.85," minimum ration (w.r.t. mode) to be drawn");
    cmd.addICmdOption("-savingfreq",&SavingFrequency,5," saving frequency of result image (1 every N)");
    SurroundOnly=true;
    Thickness=1;
    DisplayModeShape=true;
    ThicknessOfMode=2;
 
  }


};




//================================================================
// save likelihood over translation

void  SaveLikelihood(bf_EvalCondDist *pLikelihood,real state[],
		     bicv_IplImagesDataRV<uchar> *pZipl,
		     float & mini,float & maxi,bool compute_bound,
		     ipcv_Image<uchar> & IlikeChar);
  

int main (int argc, char **argv)
{

  //===========
  // USAGE 
  //===========

  MyCmdLine   mycmd;

  // Read the command line
  mycmd.cmd.read(argc, argv);

  int iter;
  
  //   bool SaveHistoLikelihood=true;
  bool SaveHistoLikelihood=false;
  
  //===========
  // DATA
  //===========

  char  fullname[256];

  sprintf(fullname,"%s/%s",mycmd.ImageDirectory,mycmd.ImageName);
  // keeping last 2 read images into memory
  ipcv_SeqImageFile<ip_ColorElement8u>       Iseq(2,fullname,mycmd.First,mycmd.Last,mycmd.Step);
  
  ip_Image<ip_ColorElement8u>                *Ima;
  //   ipcv_Image<ip_ColorElement8u>                ImaOut;
  
  ip_ImageName      output_name;
  bicv_IplImagesDataRV<uchar>       Zipl(&Iseq,mycmd.data_kind);
  
  float mini,maxi;
  
  //=============================================
  //===========
  // TRACKER
  //===========
  ip_BoundingBox               BBox;

  
  ip_PlanarTransform       *pT;
  switch(mycmd.TransformType){
  case 1:  pT= new ip_PlanarTranslationScaling; break;
  case 2:  pT= new ip_PlanarTranslationScaling2; break;
  default:  pT= new ip_PlanarTranslation; break;
  }
  
  // Set reference BBox to compute template
  int seq=-1;
  if(Iseq.m_cGenericName.m_cBaseName==chaine("clip01_")){printf("Dancers \n"); seq=0;  // dancers
  }
  if(Iseq.m_cGenericName.m_cBaseName==chaine("famili~4_")){ printf("Daniel \n"); seq=2;  // daniel
  }   
  if(Iseq.m_cGenericName.m_cBaseName==chaine("clip02_")){printf("Dad \n");seq=3;// DAD : clip02_ 03860 04185 
  }
  if(Iseq.m_cGenericName.m_cBaseName==chaine("charlie_")){printf("Running boy (charlie) \n");seq=1; 
  }// running boy : 92100 92730 1
  
  if(mycmd.botrightco<0 || mycmd.botrightli<0 || mycmd.upleftco<0 ||  mycmd.upleftli<0){
    switch(seq){
      // DAD
      //case 3:     BBox.init(53,70,90,150);      break;
    case 3:     BBox.init(55,68,90,118);      break;
    case 2:     BBox.init(176,50,232,159);    break;
    case 1:     BBox.init(185,35,232,180);    break;
    case 0:     BBox.init(125,100,156,200);   break;
    default:   printf("Sequence non repertorie. \n");
      if(mycmd.botrightco<0 || mycmd.botrightli<0 || mycmd.upleftco<0 ||  mycmd.upleftli<0){
	printf("ATTENTION : INITIALISATION INCORRECTE DE LA REGION INITIALE \n");
	exit(1);
      }
    }
  }
  
  BBox.display("Original box ");
  
  
  bicv_HistogramTracker    MyTracker(mycmd.nbsamples,pT,mycmd.splitheight,mycmd.splitwidth,
				     BBox,mycmd.numberofbin,&Zipl,mycmd.LambdaH,mycmd.ZpartitionH,
				     mycmd.TranslationStdDev,mycmd.AffineStdDev,
				     mycmd.number_of_bands);
  
  
  //=============================================
  // INITIALISATION
  
  MyTracker.init();
  
  output_name=Iseq.m_cGenericName;  // 
  output_name.m_cDirectory=chaine("./");
  switch(seq){
  case 3:    output_name.m_cBaseName=chaine("dad_track_");    break;
  case 2:    output_name.m_cBaseName=chaine("daniel_track_");    break;
  case 1:    output_name.m_cBaseName=chaine("charlie_track_");    break;
  case 0:    output_name.m_cBaseName=chaine("dancers_track_");    break;
  default :  output_name.m_cBaseName=chaine("track_");    break;
  }
  output_name.m_tType=ip_PNM;
  
  {
    bf_MixedParticleDistribution *pCurrent=(bf_MixedParticleDistribution *)MyTracker.m_pParticleFilter->m_pParticleSet;
    
    //     pCurrent->display("Initial distribution");
    
    Ima=Iseq.previousImage(0);
    //ImaOut=*Ima;
    
     int i;
     for(i=0;i<pCurrent->m_iNumberOfSamples;i++){
       MyTracker.m_pMeasurer->transformRV(pCurrent->m_pSampleSet[i]);
       
       // lets draw 
       MyTracker.m_pMeasurer->draw(*Ima,ip_YELLOW,true,false);
       //MyTracker.m_pMeasurer->draw(*Ima,ip_BLUE,false);
     }

     // saving an image    
     output_name.m_iNumber=Iseq.m_cGenericName.m_iNumber;
     SaveImage(*Ima,output_name.fullName(),ip_PNM);

   }


   //=============================================
   // run the likelihood for all data (images)

   iter=0;
   while(Zipl.dataAvailable()){
     printf("===================\niter %d \n",iter);

     int   imode=0;
     real  HighestWeight;

     real  mean[32],variance[32];// should be sufficient...


     clock_t start, stop;
     start = clock();

     // RUN N ITERATION
     MyTracker.iterateN(mycmd.SavingFrequency);

     stop = clock();
     printf("elapsed time %f\n", (float)(stop-start)/(float) (10000*CLK_TCK)); fflush(stdout);

     // DISPLAY SOME RESULT
     bf_MixedParticleDistribution *pCurrent=(bf_MixedParticleDistribution *)MyTracker.m_pParticleFilter->m_pParticleSet;
  
     // Gettint mode
     imode=pCurrent->getMode();
     pCurrent->displaySample(imode);
     HighestWeight=pCurrent->m_pWeights[imode];
     

     // Getting mean and variance
     pCurrent->getMeanVariance(mean,variance,0);


     Ima=Iseq.previousImage(1);
	  //     ImaOut=*Ima;

     // displays 
     if(mycmd.display_individuals){
       int i;
       HighestWeight *= mycmd.ratio_minimum_weight;
       
       for(i=0;i<pCurrent->m_iNumberOfSamples;i++){
	 if(pCurrent->m_pWeights[i]>HighestWeight){
	   MyTracker.m_pMeasurer->transformRV(pCurrent->m_pSampleSet[i]);
	   
	   // lets draw 
	   MyTracker.m_pMeasurer->draw(*Ima,ip_YELLOW,true,mycmd.SurroundOnly,mycmd.Thickness);
	 }
       }
     }
     else { // display mean and several items around mean
       int i;
       real  state[32];
       printf("\n");
       for(i=0;i<8;i++){
	 printf("%7.3f  ",state[i]);
       }
       printf("\n");
       for(i=0;i<8;i++){
	 printf("%7.3f  ",sqrt(variance[i]));
       }
       printf("\n");
       
       
       for(i=0;i<32;i++){	 state[i]=mean[i];       }
       for(i=4;i<32;i++){state[i]=mean[i]+2.*sqrt(variance[i]);       }
       MyTracker.m_pMeasurer->transformReal((real *)state);
       //MyTracker.m_pMeasurer->draw(*Ima,ip_BLUE);
       
       for(i=0;i<32;i++){	 state[i]=mean[i];       }
       for(i=4;i<32;i++){state[i]=mean[i]-2.*sqrt(variance[i]);       }
       MyTracker.m_pMeasurer->transformReal((real *)state);
       //MyTracker.m_pMeasurer->draw(*Ima,ip_BLUE);
       
       
       MyTracker.m_pMeasurer->transformReal((real *)mean);
       // lets draw 
       MyTracker.m_pMeasurer->draw(*Ima,ip_GREEN,true,false);
     }
     
     // lets draw the highest mode in red
     if(mycmd.DisplayModeShape){
       MyTracker.m_pMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
       MyTracker.m_pMeasurer->draw(*Ima,ip_RED,true,mycmd.SurroundOnly,mycmd.ThicknessOfMode);
     }
     
     
     if(SaveHistoLikelihood){
       ipcv_Image<uchar> IlikeChar(Ima->nbLines(),Ima->nbColumns());
       real state[32];
       pCurrent->getSample((real *)state,imode,0);
       if(iter==0)
	 SaveLikelihood(MyTracker.m_pLikelihood,state,&Zipl,mini,maxi,true,IlikeChar);
       else 
	 SaveLikelihood(MyTracker.m_pLikelihood,state,&Zipl,mini,maxi,false,IlikeChar);
		 
       MyTracker.m_pMeasurer->transformReal((real *)mean);
       MyTracker.m_pMeasurer->draw(IlikeChar,255,true,false);
       SaveImage(IlikeChar,chaine("HistoLikelihood")+Iseq.m_cGenericName.m_iNumber,ip_PGM);   
     }



     
     // saving an image    
     output_name.m_iNumber=Iseq.m_cGenericName.m_iNumber; // - step should be used
     SaveImage(*Ima,output_name.fullName(),ip_PNM);


     //-----------------------
     printf("End of iter %d \n===================\n",iter);
     iter++;
   }
     

   delete pT;
   
   return 1;

}

//================================================================
// save likelihood over translation
void  SaveLikelihood(bf_EvalCondDist *pLikelihood,real state[],
		     bicv_IplImagesDataRV<uchar> *pZipl,
		     float & mini,float & maxi,bool compute_bound,
		     ipcv_Image<uchar> & IlikeChar){
  
  int li,co,i;

  ipcv_Image<float> Ilike(IlikeChar.nbLines(),IlikeChar.nbColumns());
  //  ipcv_Image<uchar> IlikeChar(ImaOut.nbLines(),ImaOut.nbColumns());
  //ipcv_Image<float> Ilike(nbli,nbco);
  //ipcv_Image<uchar> IlikeChar(nbli,nbco);
  Ilike.init(0.);
  
  bf_RandomVariable  X;
  X.addToData(state);

  //     pCurrent->getSample((real *)state,imode,0);
  for(i=0;i<8;i++)
    printf("%7.3f  ",state[i]);
  printf("\n");

  if(compute_bound){
    mini=10.,maxi=-20;
    for(li=0;li<Ilike.nbLines();li++)
      for(co=0;co<Ilike.nbColumns();co++){
	state[2]=li; state[0]=co;
      
	Ilike(li,co)=pLikelihood->evaluateConditionalRV(pZipl,&X);
	mini=min(mini,Ilike(li,co));
	maxi=max(maxi,Ilike(li,co));
      }
  }
  else {
    for(li=0;li<Ilike.nbLines();li++)
      for(co=0;co<Ilike.nbColumns();co++){
	state[2]=li; state[0]=co;
	Ilike(li,co)=pLikelihood->evaluateConditionalRV(pZipl,&X);
      }
  }
    
  
  printf("mini=%f ,maxi=%f\n",mini,maxi);
  float  expo=0.25;
  for(li=0;li<Ilike.nbLines();li++)
    for(co=0;co<Ilike.nbColumns();co++){
      float norma=(Ilike(li,co)-mini)/(maxi-mini);
      IlikeChar(li,co)	= (uchar)max(0.,min( 255.*exp(expo*log(norma)),255));
    }
       

       
}
