/******************************************************************************
*
*
*
*
******************************************************************************/

#include <stdio.h>
#include "cv.h"        /* Basic OpenCV header file. */
#include "ipl.h"


#include "bicv_HistogramLikelihood.h"
#include "bicv_BoundingBoxesTemplate.h"
#include "bf_DistributionReal.h"
#include "bf_ExponentialDistribution.h"

#include "ipcv_ContourTemplate.h"
#include "bicv_ContourAndHistogramTracker.h"

#include "ipcv_HistogramTemplate.h"
#include "ip_BoundingBox.h"

#include "ip_PlanarTranslationScaling2.h"
#include "ip_PlanarTranslationScaling.h"
#include "ip_PlanarTranslation.h"

#include "ipcv_MultiImage.h"
#include "ip_LoadSaveImage.h"
#include "ipcv_SeqImageFile.h"

#include "bicv_IplImagesDataRV.h"
#include "bicv_IplImagesDataRV_CandH.h"
#include "CmdLine.h"

using namespace Torch;
using namespace ImageProcessing;

//================================================================
//================================================================
class  SaveAndDisplayParameters
{
public:
  // display individuals whose weight satisfay w/wmax>ratio_minimum_weight
  int     display_individuals; // 1 : particle display with sufficient weight
  float   ratio_minimum_weight;
  
  // for histogram (bounding box) : display only the outer box, not the individual ones
  bool SurroundOnly;
  // Thickness of drawing (for the individuals)  (works only for bounding box)
  int  Thickness;

  // whether we want to display the mode or not
  bool DisplayModeShape;
  // Thickness of drawing (works only for bounding box)
  int  ThicknessOfMode;
  
  // whether we want to display the mean or not
  bool DisplayMeanShape;
  // Thickness of drawing (works only for bounding box)
  int  ThicknessOfMean;
  
  // whether we want to display the standard deviation or not
  bool DisplayStdShape;
  // Thickness of drawing (works only for bounding box)
  int  ThicknessOfStd;
  
  int SavingFrequency; // frequency of saving result image
  
  // whether we want to save likelihood images
  bool SaveHistoLikelihood;
  // bound for likelihood
  float miniH,maxiH;
  float miniC,maxiC;
  float miniJ,maxiJ;
  
  // generic output name
  ip_ImageName      output_name;
  
  int   LikelihoodType;
  
  //---------------------------------
  SaveAndDisplayParameters();
  
  void  setOutputName(ip_ImageName genName,int seqCase,int likemethod,int nbsamples);

};
  

//================================================================
class MyCmdLine {
  
public:
  // define all parameters there
  CmdLine cmd;

  // parameters to put "in" the command line.
  char      *ImageDirectory;
  char      *ImageName;
  int       First;
  int       Last;
  int       Step;
  int       METHOD;


  int       TransformType;

  int       data_kind;       // 1 = HSV, 0 = RGB
  int       number_of_bands; // from the choosen data, which number of band to consider
  int       nbsamples;
  int       splitwidth,splitheight,numberofbin;

  int       botrightco,botrightli,upleftco,upleftli;

  // Dynamics related
  real      TranslationStdDev;
  real      AffineStdDev;

  // Histogram Likelihood related
  real      LambdaH;     // lambda coefficient in the exponential
  real      ZpartitionH; // partition constant
  
  // FOR CONTOUR LIKELIHOOD
  int numPtsContour;
  int measureType;
  real lineLength;
  int numPtsSearchLine;
  real K;
  real SearchLineSigma;
  
  // Display and output
  SaveAndDisplayParameters       SDP;

  MyCmdLine () : SDP(){


    // real d=14.34;
    real sigma=0.16;
    real l=1./(2.*sigma*sigma);
    //  real Z=1e9*exp(d*log(sigma));
    real Z=1.;

    // Prepare the command line
    cmd.info("Tracking a square region based on color histograms, an ellipse contour, or both");
    cmd.addText("\nArguments:");

    cmd.addSCmdArg("OneImageName",&ImageName," Name of one of the image in the sequence");
    cmd.addICmdArg("First",&First," number of the first image to process");
    cmd.addICmdArg("Last",&Last," number of the last image to process");

    cmd.addText("\nGeneral options:");
    
    cmd.addICmdOption("-step", &Step,1," step between two image number");
    cmd.addSCmdOption("-imagedir", &ImageDirectory,""," directory of the input images");

    cmd.addText("\nParticle Filter options:");
    cmd.addICmdOption("-method", &METHOD,0," likelihood to use : histogram (0), contour/ellipse (1), both multiplied (2)");
    cmd.addICmdOption("-nbsamples", &nbsamples,500," number of particle samples");
    cmd.addICmdOption("-transform", &TransformType,1," transformation to track : \n\t\t\t\t 1(translation+scale) 2(trans+scalex+scaley) others (translation)");


    cmd.addText("\nHistogram likelihood options:");
    cmd.addICmdOption("-colormodel", &data_kind,1," color model (1 = HSV, 0 = RGB)");
    cmd.addICmdOption("-colormodel", &number_of_bands,3," number of bands to keep (for histograming) \n\t\t\t\t in the chosen model");
    cmd.addICmdOption("-nbbin", &numberofbin,8," number of bins in the histogram");
    cmd.addRCmdOption("-lambdah", &LambdaH,l," lambda coefficient in exponential distribution");
    cmd.addRCmdOption("-partitionh", &ZpartitionH,Z," partition function of the exponential distribution");

    // FOR CONTOUR LIKELIHOOD
    cmd.addText("\nContour likelihood options:");
    cmd.addICmdOption("-nbcontourpts",&numPtsContour,NUMBER_SEARCH_LINES," number of contour points/search lines");
    cmd.addRCmdOption("-linelength",&lineLength,SEARCH_LINE_LENGTH," total line length in search for contour points");
    
    cmd.addICmdOption("-nbsearchlinepts",&numPtsSearchLine,-1,"number of points per search line (-1 -> = linelength)");
    cmd.addRCmdOption("-sigma", &SearchLineSigma,SEARCH_LINE_SIGMA," search line sigma for likelihood computation");

    measureType = 1; // in ContourTemplate : not really used now
    K = K_DISTRIBUTION;  // for individual (i.e. per search line) likelihood

    cmd.addText("\nInitial box options:");
    cmd.addICmdOption("-botrightco", &botrightco,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-botrightli", &botrightli,-1," line number of bottom right initial box corner");
    cmd.addICmdOption("-upleftco", &upleftco,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-upleftli", &upleftli,-1," column number of bottom right initial box corner");
    cmd.addICmdOption("-splitheight", &splitheight,1," number of box split of the height");
    cmd.addICmdOption("-splitwidth", &splitwidth,1," number of box split of the width");

    cmd.addText("\nDynamics options:");
    cmd.addRCmdOption("-trans_std", &TranslationStdDev,2.," noise standart deviation (translation components)");
    cmd.addRCmdOption("-affine_std", &AffineStdDev,0.01," noise standart deviation (affine components)");

    cmd.addText("\nOuput options :");
    cmd.addICmdOption("-individuals",&SDP.display_individuals,SDP.display_individuals,
		      " draw(1) or not (0) samples with sufficiently high likelihood weight");
    cmd.addRCmdOption("-ratioweight", &SDP.ratio_minimum_weight,SDP.ratio_minimum_weight,
		      " minimum ration (w.r.t. mode) to be drawn");
    cmd.addICmdOption("-savingfreq",&SDP.SavingFrequency,SDP.SavingFrequency,
		      " saving frequency of result image (1 every N)");

   
  }


};
//================================================================
void  SaveAndDisplayFirstFrame(ipcv_SeqImageFile<ip_ColorElement8u> &      Iseq,
			       bicv_ContourAndHistogramTracker &   MyTracker,
			       SaveAndDisplayParameters        SDP);

//================================================================
void    SaveAndDisplayCurrentImage(ipcv_SeqImageFile<ip_ColorElement8u> &      Iseq,
				   bicv_IplImagesDataRV_CandH<uchar>  &    Zipl,		
				   bicv_ContourAndHistogramTracker &   MyTracker,
				   SaveAndDisplayParameters        SDP,
				   int  iter);

//================================================================
// save likelihood over translation
void  SaveLikelihood(bf_EvalCondDist *pLikelihood,real state[],
		     bicv_IplImagesDataRV_CandH<uchar> *pZipl,int TypeZ,
		     float & mini,float & maxi,bool compute_bound,
		     ipcv_Image<uchar> & IlikeChar);
  
//================================================================
//================================================================
//==============================================================
//==============================================================

int main (int argc, char **argv)
{
  //===========
  // USAGE 
  //===========

  MyCmdLine   mycmd;

  // Read the command line
  mycmd.cmd.read(argc, argv);

  if(mycmd.numPtsSearchLine<0)
    mycmd.numPtsSearchLine=SEARCH_LINE_LENGTH;

  
   int iter;
   //===========
   // PARAMETERS
   //===========

   int  LikelihoodType;
   switch(mycmd.METHOD){
   case 0: 	LikelihoodType = LIKELIHOOD_HISTO_ONLY; break;
   case 1: 	LikelihoodType = LIKELIHOOD_CONTOUR_ONLY; break;
   case 2:	LikelihoodType = LIKELIHOOD_CONTOUR_AND_HISTO; break;
   default: 	LikelihoodType = LIKELIHOOD_HISTO_ONLY; break;
   }
	
   //===========
   // DATA
   //===========

   char  fullname[256];
   
   sprintf(fullname,"%s/%s",mycmd.ImageDirectory,mycmd.ImageName);
   // keeping last 2 read images into memory
   ipcv_SeqImageFile<ip_ColorElement8u>       Iseq(2,fullname,mycmd.First,mycmd.Last,mycmd.Step);
 
   // OPTION_PREPROCESSING: ON_LINE_RGB2Y
   bicv_IplImagesDataRV_CandH<uchar>      Zipl(&Iseq,mycmd.data_kind);


   //=============================================
   //===========
   // TRACKER
   //===========
   ip_BoundingBox               BBox;
   
   ip_PlanarTransform       *pT;
   switch(mycmd.TransformType){
   case 1:  pT= new ip_PlanarTranslationScaling; break;
   case 2:  pT= new ip_PlanarTranslationScaling2; break;
   default:  pT= new ip_PlanarTranslation; break;
   }
    
   // Set reference BBox to compute template
  // Set reference BBox to compute template
  int seq=-1;
  if(Iseq.m_cGenericName.m_cBaseName==chaine("clip01_")){printf("Dancers \n"); seq=0;  // dancers
  } // clip01_24700 25200 1
  if(Iseq.m_cGenericName.m_cBaseName==chaine("famili~4_")){ printf("Daniel \n"); seq=2;  // daniel
  }   // daniel  famili~4_30500.ppm 30500 30510 1
  if(Iseq.m_cGenericName.m_cBaseName==chaine("clip02_")){printf("Dad \n");seq=3;// DAD : clip02_ 03860 04185 
  }
  if(Iseq.m_cGenericName.m_cBaseName==chaine("charlie_")){printf("Running boy (charlie) \n");seq=1; 
  }// running boy : 92100 92730 1
 
  if(mycmd.botrightco<0 || mycmd.botrightli<0 || mycmd.upleftco<0 ||  mycmd.upleftli<0){
    switch(seq){
      // DAD
      //case 3:     BBox.init(53,70,90,150);      break;
    case 3:     BBox.init(55,68,90,118);      break;
    case 2:     BBox.init(176,50,232,159);    break;
    case 1:     BBox.init(185,35,232,180);    break;
    case 0:     BBox.init(125,100,156,200);   break;
    default:   printf("Sequence non repertorie. \n");
      if(mycmd.botrightco<0 || mycmd.botrightli<0 || mycmd.upleftco<0 ||  mycmd.upleftli<0){
	printf("ATTENTION : INITIALISATION INCORRECTE DE LA REGION INITIALE \n");
	exit(1);
      }
    }
  }
  
  BBox.display("Original box ");

  bicv_ContourAndHistogramTracker  MyTracker(mycmd.nbsamples,pT,LikelihoodType,
					     mycmd.TranslationStdDev,mycmd.AffineStdDev,
					     mycmd.splitheight,mycmd.splitwidth,
					     mycmd.numberofbin,mycmd.LambdaH,mycmd.ZpartitionH,
					     mycmd.number_of_bands,
					     mycmd.numPtsContour,mycmd.measureType,
					     mycmd.lineLength,mycmd.numPtsSearchLine,mycmd.K,
					     mycmd.SearchLineSigma,BBox,&Zipl);

  //=============================================
  // INITIALISATION
  
  MyTracker.init();

  mycmd.SDP.setOutputName(Iseq.m_cGenericName,seq,LikelihoodType,mycmd.nbsamples);  
  
  SaveAndDisplayFirstFrame(Iseq,MyTracker,mycmd.SDP);
  
  //======================================================
  //=============================================
  // run the likelihood for all data (images)

   iter=0;
   while(Zipl.dataAvailable()){
     printf("===================\niter %d \n",iter);

     clock_t start, stop;
     start = clock();

     // RUN N ITERATION
     MyTracker.iterateN(mycmd.SDP.SavingFrequency);

     stop = clock();
     printf("elapsed time %f\n", (float)(stop-start)/(float) (10000*CLK_TCK)); fflush(stdout);

     SaveAndDisplayCurrentImage(Iseq,Zipl,MyTracker,mycmd.SDP,iter);
	  
     //-----------------------
     printf("End of iter %d \n=================================\n",iter);
     iter++;
   }
     
   delete pT;
   
   
   return 1;

}

//================================================================
//================================================================
//================================================================
//---------------------------------
SaveAndDisplayParameters::SaveAndDisplayParameters()
{
  // display individuals whose weight satisfay w/wmax>ratio_minimum_weight
  display_individuals=0; // 1 : particle display with sufficient weight
  ratio_minimum_weight=0.6;
  
  SurroundOnly=true;
  Thickness=1;
  DisplayModeShape=true;
  ThicknessOfMode=2;
  DisplayMeanShape=false;
  ThicknessOfMean=2;
  DisplayStdShape=true;
  ThicknessOfStd=2;
  
  SavingFrequency=5; // frequency of saving result image
  
  // SaveHistoLikelihood=true;
  SaveHistoLikelihood=false;
  miniH=0.;      maxiH=0.7;
  miniC=0.;      maxiC=0.7;
  miniJ=0.;      maxiJ=0.7;
}

//---------------------------------
void SaveAndDisplayParameters::setOutputName(ip_ImageName genName,int seqCase,int likemethod,int nbsamples)
{

  LikelihoodType=likemethod;
  output_name=genName;  // 
  output_name.m_cDirectory=chaine("./");
  system("mkdir -p ./RESULT_TEMP");
  switch(seqCase){
  case 3:    output_name.m_cBaseName=chaine("RESULT_TEMP/dad_track");    break;
  case 2:    output_name.m_cBaseName=chaine("RESULT_TEMP/daniel_track");    break;
  case 1:    output_name.m_cBaseName=chaine("RESULT_TEMP/charlie_track");    break;
  case 0:    output_name.m_cBaseName=chaine("RESULT_TEMP/dancers_track");    break;
  default :  output_name.m_cBaseName=chaine("RESULT_TEMP/track");    break;
  }
  output_name.m_tType=ip_PNM;

  
  if(likemethod & LIKELIHOOD_HISTO)
    output_name.m_cBaseName=output_name.m_cBaseName+"_H";
  if(likemethod & LIKELIHOOD_CONTOUR)
    output_name.m_cBaseName=output_name.m_cBaseName+"_C";
  
  output_name.m_cBaseName=output_name.m_cBaseName+"_samp";
  output_name.m_cBaseName=output_name.m_cBaseName+nbsamples;
  output_name.m_cBaseName=output_name.m_cBaseName+"_";
}



//================================================================
void    SaveAndDisplayFirstFrame(ipcv_SeqImageFile<ip_ColorElement8u> &      Iseq,
				 bicv_ContourAndHistogramTracker &   MyTracker,
				 SaveAndDisplayParameters        SDP)
{
  
  printf("First Frame deb  \n"); fflush(stdout);

  ip_Image<ip_ColorElement8u>                *ImaP,*Ima;
  ipcv_Image<ip_ColorElement8u>              ImaCopy;
  bf_MixedParticleDistribution               *pCurrent;
	
  bf_ParticleFilter   *mPart;

  mPart=MyTracker.m_pParticleFilter;
  pCurrent=(bf_MixedParticleDistribution *)mPart->m_pParticleSet;
  
  //  pCurrent->display("Initial distribution");
  
  ImaP=Iseq.previousImage(0);

  ImaCopy=*ImaP;
  Ima=&ImaCopy;

  int i;
  for(i=0;i<pCurrent->m_iNumberOfSamples;i++){
    MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[i]);
    
    // lets draw 
    MyTracker.m_pHistoMeasurer->draw(*Ima,ip_YELLOW,true,false);
    //MyTracker.m_pHistoMeasurer->draw(*Ima,ip_BLUE,false);

    
    if(SDP.LikelihoodType & LIKELIHOOD_CONTOUR){

      MyTracker.m_pContourMeasurer->transformRV(pCurrent->m_pSampleSet[i]);
     MyTracker.m_pContourMeasurer->draw(Ima,ip_YELLOW,MyTracker.m_pContourTemplate,
					 true,false,false);
     //  printf("First Frame OUT CONTOUR \n"); fflush(stdout);
    }
    
  }
  
  // saving an image    
  SDP.output_name.m_iNumber=Iseq.m_cGenericName.m_iNumber;
  SaveImage(*Ima,SDP.output_name.fullName(),ip_PNM);
  
}



//================================================================
// save likelihood over translation
void  SaveLikelihood(bf_EvalCondDist *pLikelihood,real state[],
		     bicv_IplImagesDataRV_CandH<uchar> *pZipl,int TypeZ,
		     float & mini,float & maxi,bool compute_bound,
		     ipcv_Image<uchar> & IlikeChar){
  
  int li,co,i;
  
  ipcv_Image<float> Ilike(IlikeChar.nbLines(),IlikeChar.nbColumns());
  //  ipcv_Image<uchar> IlikeChar(ImaOut.nbLines(),ImaOut.nbColumns());
  //ipcv_Image<float> Ilike(nbli,nbco);
  //ipcv_Image<uchar> IlikeChar(nbli,nbco);
  Ilike.init(0.);
  
  bf_RandomVariable  X,Zdata;
  X.addToData(state);

  float  expo=0.25;
  switch(TypeZ){
  case 0:
	 Zdata.addToData(pZipl->m_cData.nodes[0]);
	 expo=0.25;
	 break;

  case 1:
	 Zdata.addToData(pZipl->m_cData.nodes[1]);
	 expo=0.25;
	 break;

  case -1:
	 Zdata.addToData(pZipl->m_cData.nodes[0]);
	 Zdata.addToData(pZipl->m_cData.nodes[1]);
	 expo=0.125;
	 break;
  }
  
  //     pCurrent->getSample((real *)state,imode,0);
  for(i=0;i<8;i++)
    printf("%7.3f  ",state[i]);
  printf("\n");

  int step=1;

  if(compute_bound){
    mini=10.,maxi=-20;
    for(li=0;li<Ilike.nbLines();li+=step)
      for(co=0;co<Ilike.nbColumns();co+=step){
	state[2]=li; state[0]=co;
	
	Ilike(li,co)=pLikelihood->evaluateConditionalRV(&Zdata,&X);
	if(Ilike(li,co)>0.0){
	  mini=min(mini,Ilike(li,co));
	  maxi=max(maxi,Ilike(li,co));
	}
	
      }
  }
  else {
    for(li=0;li<Ilike.nbLines();li+=step)
      for(co=0;co<Ilike.nbColumns();co+=step){
	state[2]=li; state[0]=co;
	Ilike(li,co)=pLikelihood->evaluateConditionalRV(&Zdata,&X);
      }
  }
  
  
  printf("mini=%f ,maxi=%f\n",mini,maxi);
  for(li=0;li<Ilike.nbLines();li+=step)
    for(co=0;co<Ilike.nbColumns();co+=step){
      float norma=(Ilike(li,co)-mini)/(maxi-mini);
      IlikeChar(li,co)	= (uchar)max(0.,min( 255.*exp(expo*log(norma)),255));
    }
  
}


//================================================================
void    SaveAndDisplayCurrentImage(ipcv_SeqImageFile<ip_ColorElement8u> &      Iseq,
				   bicv_IplImagesDataRV_CandH<uchar>  &    Zipl,		
				   bicv_ContourAndHistogramTracker &   MyTracker,
				   SaveAndDisplayParameters        SDP,
				   int  iter)
{
  ip_Image<ip_ColorElement8u>                *ImaP,*Ima;
  ipcv_Image<ip_ColorElement8u>              ImaCopy;
  
  bf_MixedParticleDistribution *pCurrent;
  int   imode=0;
  real  HighestWeight;
  
  real  mean[32],variance[32];// should be sufficient...
  

  // DISPLAY SOME RESULT
  pCurrent=(bf_MixedParticleDistribution *)MyTracker.m_pParticleFilter->m_pParticleSet;
  
  // Gettint mode
  imode=pCurrent->getMode();
  pCurrent->displaySample(imode);
  HighestWeight=pCurrent->m_pWeights[imode];
  

  // Getting mean and variance
  pCurrent->getMeanVariance(mean,variance,0);
  
  ImaP=Iseq.previousImage(1);
  ImaCopy=*ImaP;
  Ima=&ImaCopy;
  
  // displays 
  if(SDP.display_individuals){
    int i;
    HighestWeight *= SDP.ratio_minimum_weight;
    
    for(i=0;i<pCurrent->m_iNumberOfSamples;i++){
      if(pCurrent->m_pWeights[i]>=HighestWeight){
	MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[i]);
	
	// lets draw 
	MyTracker.m_pHistoMeasurer->draw(*Ima,ip_YELLOW,true,SDP.SurroundOnly,SDP.Thickness);
	
	// lets draw
	MyTracker.m_pContourMeasurer->transformRV(pCurrent->m_pSampleSet[i]);	 	  
	MyTracker.m_pContourMeasurer->draw(Ima,ip_YELLOW, MyTracker.m_pContourTemplate,
					   true,false,false);    	 
	
      }
    }
  }

  if(SDP.DisplayMeanShape){
    int i;
    real  state[32];
    printf("\n");
    for(i=0;i<8;i++){
      printf("%7.3f  ",state[i]);
    }
    printf("\n");
    for(i=0;i<8;i++){
      printf("%7.3f  ",sqrt(variance[i]));
    }
    printf("\n");
    
    
    if(SDP.DisplayStdShape){
      for(i=0;i<32;i++){	 state[i]=mean[i];       }
      for(i=4;i<32;i++){   state[i]=mean[i]+2.*sqrt(variance[i]);       }
      MyTracker.m_pHistoMeasurer->transformReal((real *)state);
      MyTracker.m_pHistoMeasurer->draw(*Ima,ip_BLUE,SDP.SurroundOnly,SDP.ThicknessOfStd);
      
      for(i=0;i<32;i++){	 state[i]=mean[i];       }
      for(i=4;i<32;i++){state[i]=mean[i]-2.*sqrt(variance[i]);       }
      MyTracker.m_pHistoMeasurer->transformReal((real *)state);
      MyTracker.m_pHistoMeasurer->draw(*Ima,ip_BLUE,SDP.SurroundOnly,SDP.ThicknessOfStd);
    }
    
    MyTracker.m_pHistoMeasurer->transformReal((real *)mean);
    MyTracker.m_pHistoMeasurer->draw(*Ima,ip_GREEN,SDP.SurroundOnly,SDP.ThicknessOfMean);
  }
  
	  
  // lets draw the highest mode in red
  if(SDP.DisplayModeShape){
    if(SDP.LikelihoodType & LIKELIHOOD_HISTO){
      MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pHistoMeasurer->draw(*Ima,ip_RED,true,SDP.SurroundOnly,SDP.ThicknessOfMode);
    }
    
    if(SDP.LikelihoodType & LIKELIHOOD_CONTOUR){
      MyTracker.m_pContourMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pContourMeasurer->draw(Ima,ip_RED,MyTracker.m_pContourTemplate,
					 true,false,false);
    }
    
    /*
      if(SDP.LikelihoodType & LIKELIHOOD_BACKGROUND){
      MyTracker.m_pBackgroundMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pBackgroundMeasurer->draw(*Ima,ip_RED,true,SDP.SurroundOnly,
      SDP.ThicknessOfMode);
      }
    */
    
  }
  
  // saving an image    
  SDP.output_name.m_iNumber=Iseq.m_cGenericName.m_iNumber; // - step should be used
  SaveImage(*Ima,SDP.output_name.fullName(),ip_PNM);
  

  if(SDP.SaveHistoLikelihood){
    ipcv_Image<uchar> IlikeChar(Ima->nbLines(),Ima->nbColumns());
    real state[32];
    int TypeData;
    
    if(SDP.LikelihoodType & LIKELIHOOD_HISTO){
      pCurrent->getSample((real *)state,imode,0);
      TypeData=0;
      
      if(iter==-1)
	//			if(iter==-0)
	SaveLikelihood(MyTracker.m_pHistoLikelihood,state,&Zipl,TypeData,
		       SDP.miniH,SDP.maxiH,true,IlikeChar);
      else 
	SaveLikelihood(MyTracker.m_pHistoLikelihood,state,&Zipl,TypeData,
		       SDP.miniH,SDP.maxiH,false,IlikeChar);
      
      MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pHistoMeasurer->draw(IlikeChar,255,true,false);
      SaveImage(IlikeChar,chaine("HistoLikelihood")+Iseq.m_cGenericName.m_iNumber,ip_PGM);   
    }
    
    if(SDP.LikelihoodType & LIKELIHOOD_CONTOUR){
      pCurrent->getSample((real *)state,imode,0);
      IlikeChar.init(0);
      TypeData=1;
      
      //			if(iter==0)
      if(iter==-1)
	SaveLikelihood(MyTracker.m_pContourLikelihood,state,&Zipl,TypeData,
		       SDP.miniC,SDP.maxiC,true,IlikeChar);
      else 
	SaveLikelihood(MyTracker.m_pContourLikelihood,state,&Zipl,TypeData,
		       SDP.miniC,SDP.maxiC,false,IlikeChar);
      
      MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pHistoMeasurer->draw(IlikeChar,255,true,false);
      SaveImage(IlikeChar,chaine("ContourLikelihood")+Iseq.m_cGenericName.m_iNumber,ip_PGM);   
    }
    
    
    if(SDP.LikelihoodType & LIKELIHOOD_CONTOUR && SDP.LikelihoodType & LIKELIHOOD_HISTO){
      pCurrent->getSample((real *)state,imode,0);
      IlikeChar.init(0);
      TypeData=-1;
      //			if(iter==0)
      if(iter==-1)
	SaveLikelihood(MyTracker.m_pLikelihood,state,&Zipl,TypeData,
		       SDP.miniJ,SDP.maxiJ,true,IlikeChar);
      else 
	SaveLikelihood(MyTracker.m_pLikelihood,state,&Zipl,TypeData,
		       SDP.miniJ,SDP.maxiJ,false,IlikeChar);
      
      MyTracker.m_pHistoMeasurer->transformRV(pCurrent->m_pSampleSet[imode]);
      MyTracker.m_pHistoMeasurer->draw(IlikeChar,255,true,false);
      SaveImage(IlikeChar,chaine("JointLikelihood")+Iseq.m_cGenericName.m_iNumber,ip_PGM);   
      
    }
    
  } // if save likelihood
  
}

