#include "macros.h"                   // for MyArrondi
#include "ipcv_ContourTemplate.h"
#include "ip_Ellipse.h"
#include "bicv_TransformedEllipseTemplate.h"


using namespace ImageProcessing;

namespace Torch {

  //-----
  bicv_TransformedEllipseTemplate::bicv_TransformedEllipseTemplate()
  { 
    m_pEllipseTemplate = NULL;
    m_pEllipseCurrent = NULL;
    m_pTransform = NULL;
    m_bTemplateAllocated = false;
    m_iStepGet = 1; 
    m_bCurrentInside = false;
  }

  
  //-----
  bicv_TransformedEllipseTemplate::bicv_TransformedEllipseTemplate(ip_PlanarTransform *pTransf,
								   bool AllocateMemTemp)
  { 
    m_pEllipseTemplate = NULL;
    m_pEllipseCurrent = NULL;
    m_pTransform = pTransf;
    m_bTemplateAllocated = AllocateMemTemp;
    m_iStepGet = 1; 
    setStepSet(1);
    create(NULL,pTransf,AllocateMemTemp);
  }
  

  //-----
  bicv_TransformedEllipseTemplate::bicv_TransformedEllipseTemplate(ip_Ellipse *pEllipseTemplate,
								   ip_PlanarTransform *pTransf,	
								   bool AllocateMemTemp,
								   bool with_center)
  {     
    m_pEllipseTemplate = NULL;
    m_pEllipseCurrent = NULL;
    m_bTemplateAllocated = AllocateMemTemp;
    m_pTransform = pTransf;
    m_iStepGet = 1;     
    setStepSet(1);    

    create(pEllipseTemplate,pTransf,AllocateMemTemp,with_center);
  }
  

  //----
  void  bicv_TransformedEllipseTemplate::create(ip_Ellipse *pEllipseTemplate,
						ip_PlanarTransform *pTransf,	    
						bool AllocateMemTemp,
						bool with_center)
  {
    if(m_pTransform!=NULL){
      pTransf->m_iStepRead = m_pTransform->m_iStepRead;
    }
    else 
      pTransf->m_iStepRead=1;

    m_bTemplateAllocated = AllocateMemTemp;
    m_pTransform = pTransf;    

    if(m_pEllipseCurrent != NULL)
      freeMemory();
    m_pEllipseCurrent = new ip_Ellipse; 

    if(m_bTemplateAllocated == true) 
      m_pEllipseTemplate = new ip_Ellipse; 
    else
      m_pEllipseTemplate = pEllipseTemplate;  

    setEllipse(pEllipseTemplate,with_center);

    //initialize the current ellipse with the original template
    m_pEllipseCurrent->init(m_pEllipseTemplate);
    m_bCurrentInside = false;  

  }


  //----
  ip_Pixel bicv_TransformedEllipseTemplate::computeCenter(void)
  {
    return ip_Pixel(m_pEllipseTemplate->m_pCentroid->m_rX, m_pEllipseTemplate->m_pCentroid->m_rY);
  }


  //----
  ip_Pixel bicv_TransformedEllipseTemplate::getCenter(void)
  {
    return m_cCenter;
  }


  //----
  void  bicv_TransformedEllipseTemplate::center(void)
  {
    m_cCenter=computeCenter();
    if(m_pEllipseTemplate != NULL)
    {
      m_pTransform->setIdentity();

      // translation to compensate for the center location
      m_pEllipseTemplate->translate(-m_cCenter.m_iCo,-m_cCenter.m_iLi);

      //transform the parameters of the ellipse
      m_pEllipseTemplate->getExtremePointsFromPars();

      // change transform in order to translate in the other direction 
      m_pTransform->translate(m_cCenter.m_iCo,m_cCenter.m_iLi);
    }
  }


  //----
  void bicv_TransformedEllipseTemplate::setEllipse(ip_Ellipse *pEllipseTemplate,
						     bool with_center)
  {
    if(m_bTemplateAllocated == false){
		if(pEllipseTemplate != NULL)
		  m_pEllipseTemplate = pEllipseTemplate;
	 }
	 else {
		if(pEllipseTemplate != NULL)
		  *m_pEllipseTemplate = *pEllipseTemplate;
	 }
	 

    if(with_center)
      center();

  }


  //---- 
  void bicv_TransformedEllipseTemplate::transformEllipse(ip_Ellipse *pIn, ip_Ellipse *pOut)
  {
    ip_Point im;
    // transforms extreme points  
    for(int i=0;i<4;i++)
    {                  
      im = m_pTransform->imageReal(pIn->m_pExtremePoints[i].m_rX,pIn->m_pExtremePoints[i].m_rY);
      pOut->m_pExtremePoints[i].m_rX = im.m_rX;
      pOut->m_pExtremePoints[i].m_rY = im.m_rY;     
    }
    
    // and now computes new parameters
    pOut->getParsFromExtremePoints();
  }


  //----  
  void bicv_TransformedEllipseTemplate::transform(void)
  {    
    if(m_pEllipseTemplate!=NULL)
    {      
      transformEllipse(m_pEllipseTemplate, m_pEllipseCurrent); 
    }
    else 
    {
      printf("\n WARNING : ORIGINAL ELLIPSE NOT SET YET \n\n");
      fflush(stdout);
      exit(0);
    }      
  }

  
  //---- note: this implementation is quite inefficient (4 loops instead of only one)
  bool bicv_TransformedEllipseTemplate::computeContourMeasurements(ip_Image <ip_ColorElement8u> *pImage,
								   ipcv_ContourTemplate *pCT)
  {
    real threshold = EDGE_THRESHOLD;
    int sigma = SIGMA_FILTER_EDGE_DETECTION;
    real cols = pImage->nbColumns();
    real rows = pImage->nbLines();

    // perform computation and return true only if the current ellipse is "inside enough" the image
    if(m_pEllipseCurrent->insideEnough(pImage->nbLines(), pImage->nbColumns()) ) 
    {
      m_bCurrentInside = true;	     
      m_pEllipseCurrent->samplePoints(pCT->m_pPointList, pCT->m_iNumberOfPoints);
      pCT->validatePointsOnContour(rows, cols);
      pCT->computeLineSegments(m_pEllipseCurrent, rows, cols);
      pCT->computeEdgeFeatures(pImage, sigma, threshold);  
      return true;
    }
    else
    {
      m_bCurrentInside = false;      
      return false;
    }
  }
  
/*
  //---- new implementation: two loops only...
  bool bicv_TransformedEllipseTemplate::computeContourMeasurements(ip_Image <ip_ColorElement8u> *pImage,
								   ipcv_ContourTemplate *pCT)
  {
    real threshold = EDGE_THRESHOLD;
    int sigma = SIGMA_FILTER_EDGE_DETECTION;
    real cols = pImage->nbColumns();
    real rows = pImage->nbLines();

    // perform computation and return true only if the current ellipse is "inside enough" the image
    if(m_pEllipseCurrent->insideEnough(pImage->nbLines(), pImage->nbColumns()) ) 
    {
      m_bCurrentInside = true;	     
      m_pEllipseCurrent->samplePoints(pCT->m_pPointList, pCT->m_iNumberOfPoints);      
      pCT->extractEdgeFeatures(m_pEllipseCurrent, rows, cols, pImage, sigma, threshold);
      return true;
    }
    else
    {
      m_bCurrentInside = false;      
      return false;
    }
  }
*/



  //---- PENDING: the version for IplImage: not done yet
  bool bicv_TransformedEllipseTemplate::computeContourMeasurements(IplImage **pImage,
								    ipcv_ContourTemplate *pCT)
  {
    return true;
  }


  //----
  // to draw contours, we might choose: the contour, the lines, and the features.
  void   bicv_TransformedEllipseTemplate::draw(ip_Image<ip_ColorElement8u> *pImage,
					       ip_ColorElement8u color,
					       ipcv_ContourTemplate *pCT,
					       bool drawCurrentContour, 
					       bool drawLines,
					       bool drawFeatures)
  {   

    if(drawCurrentContour == true)
      {
	// draw only if the current ellipse is "inside enough" the image
	if(m_pEllipseCurrent->insideEnough(pImage->nbLines(), pImage->nbColumns()) == true)
	  {      
	    //plot the transformed ellipse 
	    m_pEllipseCurrent->samplePoints(pCT->m_pPointList, pCT->m_iNumberOfPoints);
	    pCT->validatePointsOnContour( pImage->nbLines(), pImage->nbColumns() );
	    //get the line information
	    pCT->computeLineSegments(m_pEllipseCurrent, pImage->nbLines(), pImage->nbColumns());
	    //detect features
	    real threshold = EDGE_THRESHOLD;
	    int sigma = SIGMA_FILTER_EDGE_DETECTION;
	    pCT->computeEdgeFeatures(pImage, sigma, threshold);
	    
	    //draw stuff
	    m_pEllipseCurrent->draw(pCT->m_pPointList, pCT->m_iNumberOfPoints, pImage,color);     
	    if(drawLines == true)
	      pCT->drawLineSegments(pImage, color);
	    if(drawFeatures == true)
	      pCT->drawFeatures(pImage, ip_BLUE);
	  }
      }
    else   
      { 
	// only plot the original ellipse: no lines or anything
	m_pEllipseTemplate->samplePoints(pCT->m_pPointList, pCT->m_iNumberOfPoints);
	//pCT->validatePointsOnContour( pImage->nbLines(), pImage->nbColumns() );
	m_pEllipseTemplate->draw(pCT->m_pPointList, pCT->m_iNumberOfPoints,pImage,color);
      }      
  }
  

  //----
  void  bicv_TransformedEllipseTemplate::freeMemory()
  {  
    if(m_pEllipseCurrent != NULL)
    {
      delete  m_pEllipseCurrent;
      m_pEllipseCurrent = NULL;
    }
    if(m_bTemplateAllocated == true)
      if(m_pEllipseCurrent != NULL)
	{
	  delete  m_pEllipseTemplate;
	  m_pEllipseTemplate = NULL;
	}
  }
 
}

