#include "bicv_HistogramTracker.h"
#include "bf_ExponentialDistribution.h"
#include "bf_ParticleFilter.h"
#include "bf_LikelihoodProduct.h"
#include "bi_PlanarTransformStateLikelihood.h"

using namespace ImageProcessing;

namespace Torch {

  //================================================================

  //-- constructors
  bicv_HistogramTracker::bicv_HistogramTracker(int NberOfParticles, ip_PlanarTransform *T,
					       int SplitHeight,int SplitWidth,
					       ip_BoundingBox   initBB,
					       int  DIM_C,
					       bf_DataRandomVariable *pZ,
					       real Lambda,real Z,
					       real DynamicsTranslationStdev,
					       real DynamicsAffineStdev,
					       int  number_of_bands) :
    bf_Trainer(NULL,pZ) {
    int n,i;

    m_iNumberOfBands=number_of_bands;
    
    // construct the differents elements of the particle filter
    
    // number of parameters of transform
    n=T->nbParams();
    
    // the dynamical model.
    real  * Var;
    Var = new real [n];
    for(i=0;i<min(2,n);i++)
      Var[i]=DynamicsTranslationStdev*DynamicsTranslationStdev;

    for(i=2;i<n;i++)
      Var[i]=DynamicsAffineStdev*DynamicsAffineStdev;
    // m_pDynamics= new bf_DynamicAR2(n,Var);
    m_pDynamics= new bf_DynamicAR3(n,Var);
    //     m_pDynamics= new bf_DynamicAR2bis(n,Var);
    //m_pDynamics= new bf_DynamicAR3bis(n,Var);
    delete [] Var;
    
    // the particles
    m_pRng1=new bf_RandomGenerator(3);
    m_pRng2=new bf_RandomGenerator(2);
    m_pPosteriorDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							      m_pDynamics->nbStates(),0,
							      m_pRng1);  
    m_pAuxDistribution=new bf_MixedParticleDistribution(NberOfParticles,1,
							m_pDynamics->nbStates(),0,
							m_pRng2);      
    
    // The histogram Likelihood
    
    int nbpos=SplitWidth*SplitHeight;
    // working on m_iNumberOfBands bands, with a range of [0.255], and DIM_C boxe per axis
    m_pTemplate= new ipcv_HistogramTemplate(nbpos,m_iNumberOfBands,DIM_C,0.,255.);
    
    m_pTrans=T;
    m_pMeasurer=new bicv_ChessBoardTemplate ;
    m_pMeasurer->create(SplitWidth,SplitHeight,T);

    //
    m_cInitBB=initBB;

    // 
    m_pProbaLikelihood = new bf_ExponentialDistribution(Lambda,Z);

    if(T->planarModel()==PLANAR_TRANSLATION_SCALING2){
      int  Tab[2]; 

      m_pLikelihoodTable = new bf_EvalCondDist * [2];
      m_iNumberOfLikelihood = 2;
      m_pLikelihoodTable[0] = new  bicv_HistogramLikelihood(m_pTemplate,m_pMeasurer,
						  m_pProbaLikelihood);
      m_pLikelihoodTable[1]=new bi_PlanarTransformStateLikelihood(T->planarModel(),
								  m_pDynamics->nbStates(0));

      Tab[0]=0; Tab[1]=0;
      m_pLikelihood = new bf_LikelihoodProduct(m_pLikelihoodTable,Tab,m_iNumberOfLikelihood);

    }
    else {
      m_pLikelihoodTable = NULL;
      m_iNumberOfLikelihood = 0;
      m_pLikelihood = new  bicv_HistogramLikelihood(m_pTemplate,m_pMeasurer,
						  m_pProbaLikelihood);
    }
    
    // finally, lets create the filter;
    m_pParticleFilter = new bf_ParticleFilter(m_pPosteriorDistribution,
					      m_pAuxDistribution,
					      m_pDynamics,m_pLikelihood);
    m_pBayesFilter = m_pParticleFilter;
  }

  //================================================================

  //-- 
  void bicv_HistogramTracker::init(long N){
    bf_Trainer::init(N);

    //-----------
    m_pMeasurer->setSurroundingBB(m_cInitBB,true);
    m_pMeasurer->transform();

     // we need to initialize the template image
    m_pMeasurer->computeHistogram((IplImage **)m_pDataInput->m_cData.nodes[0],m_pTemplate);

    //-----------
    // need to recover parameters to initialize particles
    real *initpar=new real [m_pDynamics->nbStates()];
    real *initconfig=new real [m_pDynamics->nbStates()]; // indeed less than nbStates is needed
    m_pMeasurer->setStepGet(1);
    m_pMeasurer->getTransformReal(initconfig);
    m_pDynamics->initState(initpar,initconfig);
    
    m_pPosteriorDistribution->setAllSample(initpar,0);

    // IMPORTANT :
    // set which parameters of the state are usefull
    // for updating object configuration.

    m_pMeasurer->setStepSet(m_pDynamics->nbStates(0));
    
    delete [] initconfig;
    delete [] initpar;


  }
  
  //================================================================
  
  bicv_HistogramTracker::~bicv_HistogramTracker(){
    int i;
    delete m_pDynamics;
    delete m_pRng1;
    delete m_pRng2;
    delete m_pPosteriorDistribution;
    delete m_pAuxDistribution;
    delete m_pTemplate;
    delete m_pMeasurer;
    delete m_pProbaLikelihood;
    delete m_pParticleFilter;
    delete m_pLikelihood;
    if(m_iNumberOfLikelihood>0){
      for(i=0;i<m_iNumberOfLikelihood;i++)
	delete m_pLikelihoodTable[i];
      delete [] m_pLikelihoodTable;
    }
  }
  
}
