#ifndef BICV_CHESS_BOARD_TEMPLATE_INC
#define BICV_CHESS_BOARD_TEMPLATE_INC

#include "general.h"

// open cv
#include "cv.h"

#include "bicv_BoundingBoxesSetTemplate.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

      Object = a set of Bounding boxes that pad one bounding
      box.
      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //
  //===================================================

  class   bicv_ChessBoardTemplate : virtual public bicv_BoundingBoxesSetTemplate  {

    //-- members

  public:
    int               m_iNbSplitCo;
    int               m_iNbSplitLi;

  private:
    ip_BoundingBox    m_cSurroundingBox;


    //-- member functions
    
  public:

    //================================================================

    //-- constructors

    //-----
    bicv_ChessBoardTemplate();

    //-----
    bicv_ChessBoardTemplate(int SplitCo, int SplitLi,
			    ip_PlanarTransform *Transf);

    //-----
    bicv_ChessBoardTemplate(int SplitCo, int SplitLi,
			    ip_PlanarTransform *Transf,
			    ip_BoundingBox *  BBox,
			    bool with_center=false);

    //================================================================

    //-- memory management


    //----
    virtual void  create(int SplitCo, int SplitLi,
			 ip_PlanarTransform *Transf,
			 ip_BoundingBox  * BBox=NULL,
			 bool with_center=false);
    
    

    //----
    virtual void  freeMemory();

    //================================================================

    virtual void setSurroundingBB(ip_BoundingBox SBB,bool with_center=false);

    //----

    virtual void draw(ip_Image<ip_ColorElement8u> &Ima,
		      ip_ColorElement8u color,bool current=true,
		      bool surrounding=true,
		      int thickness = 2);

    //----

    virtual void draw(ip_Image<uchar> &Ima,
		      uchar color,bool current=true,bool surrounding=true);

    //================================================================
    
    virtual ~bicv_ChessBoardTemplate();

  };

   
}

#endif
