#ifndef BICV_BOUNDING_BOXES_SET_TEMPLATE_INC
#define BICV_BOUNDING_BOXES_SET_TEMPLATE_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"
#include "bf_DistributionReal.h"

#include "bf_RVFunctions.h"

// open cv
#include "cv.h"

#include "ipcv_HistogramTemplate.h"
#include "bi_HistogramMeasurer.h"
#include "ip_BoundingBox.h"
#include "ip_PlanarTransform.h"

#include "bicv_BoundingBoxesTemplate.h"

using namespace ImageProcessing;

namespace Torch {
  //-----

  /** 

      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //  Object defined by a set of bounding boxes.
  // 
  //  Property used is color multidimensional histograms
  //
  //  BUT here, several bounding boxes can be used
  //     to compute a given histogram (i.e. if we want to 
  //     compute one histogram from multiple parts)
  //
  //  Thus, we inherit from standart BoundingBoxTemplate
  //    and provide, at initialisation, the number of dimensionalities,
  //    and the number of boxes in the list that correspond to a particular
  //    dimension.
  // 
  //  Transformation are planar transformation
  //
  //  Transform  of a bounding box b = bounding box that 
  //              includes the 4 transform of the cornes of b.
  //
  //  Parameters of the configuration : 
  //      - should be provided inside a vector of reals.
  //        This vector may contain other parameters not related
  //         to the configuration. Nevertheless, the "useful"
  //         parameters (i.e. the ones that define the configuration) 
  //         should be placed regularly in this vector, the first one
  //         being at the 0 position.
  //      - when providing the configuration parameters (cf setTransformReal)
  //        the "step size" between two useful parameters in the input 
  //        vector can be set with the setStepSet() function.
  //      - when recovering configuration parameters (getTransformReal)
  //        the "step size" between two places to store two consecutive parameters
  //        can be specified with the setStepGet() function.
  //
  //===================================================

  class   bicv_BoundingBoxesSetTemplate : virtual public bicv_BoundingBoxesTemplate {
  public:
    int                     m_iNberOfDimensions;
    int                     *m_pNbBBoxesPerDimension;
    
  public:

    //-----
    bicv_BoundingBoxesSetTemplate();

    //-----
    bicv_BoundingBoxesSetTemplate(int NbBBoxes,ip_PlanarTransform *Transf,
				  bool AllocateMemTemp=false);

    //-----
    bicv_BoundingBoxesSetTemplate(ip_BoundingBox   *BBTemplate,
				  int NbBBoxes,ip_PlanarTransform *Transf,
				  bool AllocateMemTemp=false,
				  bool with_center=false);


    //----
    virtual void  create(ip_BoundingBox   *BBTemplate,
			 ip_PlanarTransform *Transf,
			 int                 NbBBoxes,
			 bool AllocateMemTemp=false,
			 bool with_center=false);

    virtual void  create(ip_BoundingBox   *BBTemplate,
			 ip_PlanarTransform *Transf,
			 int                 NbBBoxes,
			 int                 NbDim,
			 int                *nbBoxPerDim,
			 bool AllocateMemTemp=false,
			 bool with_center=false);

    // create (and copy from input) the distribution of boxes over the dimensions
    // if nbboxes==nbdim, assumes one box per dim
    void   createNbBBoxesPerDim(int nbboxes,int nbdim,int *nbBoxPerDim=NULL);
    


    //----
    // Inherited from BoundingBoxesTemplate
    //    inline int    nbBoxes(){ return m_iNbBBoxes;}
    //----

    inline  int  nbDimensions()  {return m_iNberOfDimensions;      }
    

    //--------------------
    // Inherited from BoundingBoxesTemplate
    //    virtual void setStepSet(int step) { m_pTransform->m_iStepRead=step;}
 
    //--------------------
    // Inherited from BoundingBoxesTemplate
    //    virtual void setStepGet(int step) { m_iStepGet=step; }

    //--------------------
    // Inherited from BoundingBoxesTemplate
    // compute the center of gravity of the current bouding boxes
    //    virtual ip_Pixel   computeCenter();

    //---------------------
    // retrieve the center of gravity of template BB, used last call to center() 
    // Inherited from BoundingBoxesTemplate
    //    virtual ip_Pixel getCenter();

    //---------------------
    // center the template BB around the center of gravity
    // Inherited from BoundingBoxesTemplate
    // virtual void center();

    //---------------------
    //-- set the bounding box template with initialisation
    // Inherited from BoundingBoxesTemplate
    //    virtual void   setBB(ip_BoundingBox   *BBTemplate,bool with_center=true);

    // MINIMUM FUNCTIONS TO BE DEFINED :
    // Inherited from BoundingBoxesTemplate
    // virtual bool isReal() { return true;}

    // Inherited from BoundingBoxesTemplate
    //    virtual int nbParam();

    //----
    // Inherited from BoundingBoxesTemplate
    //    virtual ip_BoundingBox  transformBB(ip_BoundingBox & BBin);

    //----
    // from bi_ShapeTransformTemplate
    // Inherited from BoundingBoxesTemplate
    //    virtual void transform(void);
    
    //-----
    // from bi_ShapeTransformTemplate
    // Inherited from BoundingBoxesTemplate
    //    virtual inline void getTransformReal(real *pTrPars);

    //----- dgp
    // inherited from bi_ShapeTransformTemplate
    // Inherited from BoundingBoxesTemplate
    //    virtual inline real *getTransformReal(void);

    //-----
    // from bi_ShapeTransformTemplate
    // Inherited from BoundingBoxesTemplate
    //    virtual inline void setTransformReal(real *pTrPars);

    //----
    // from HistogramMeasurer
    virtual bool  computeHistogram(IplImage **bands,
				   ipcv_HistogramTemplate *H);


    // ----
    // Inherited from BoundingBoxesTemplate
    //    virtual void   draw(ip_Image<ip_ColorElement8u> &Ima,ip_ColorElement8u color,
    //		bool current=true);
    
     // ----
    // Inherited from BoundingBoxesTemplate
    //    virtual void   draw(ip_Image<uchar> &Ima,uchar color,
    //		bool current=true);
    
    //----
    // private:
    virtual void  freeMemory();

    //----
  public:
    virtual ~bicv_BoundingBoxesSetTemplate(){
      freeMemory();
    }

  };

   
}

#endif
