#ifndef BF_TRAINER_INC
#define BF_TRAINER_INC

#include "general.h"
#include "bf_DataRandomVariable.h"
#include "bf_BayesFilter.h"


namespace Torch {

//-----

/** Implements the basic trainer for Bayes filters

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bf_Trainer 
  { 
    public:
      
    //data members 

    bf_BayesFilter            *m_pBayesFilter;
    bf_DataRandomVariable     *m_pDataInput;
    long                       m_lMaxNumberOfIterations;


    //member functions 

    //-----
    bf_Trainer(bf_BayesFilter *pBF, bf_DataRandomVariable *pData);

    //-----
    virtual void init(long N=-1);

    //----- may be redefined for each specific case
    virtual void initData(void);

    //----- may be redefined for each specific case 
    virtual void nextData(void);

    //----- may be redefined for each specific case 
    virtual bool dataAvailable(void);

    //-----
    // ATTENTION : THIS ONE DOES NOT 
    // CHANGE DATA
    virtual void iterate(void);

    //-----------------
    // Iterate N times
    // After each iteration, data are changed
    virtual void iterateN(long N);

    //-----
    virtual ~bf_Trainer();

  };


}

#endif




