#include <stdlib.h>
#include "general.h"
#include "bf_RandomGenerator.h"
#include "bf_ParticleDistribution.h"



namespace Torch {

  bf_ParticleDistribution::bf_ParticleDistribution(int N,bf_RandomGenerator *rng){
    m_iNumberOfSamples=0;
    m_dTotalCumWeight=0.;
    create(N,rng);
  }

  //----- constructor: receives a pointer to pointers to RV

  bf_ParticleDistribution::bf_ParticleDistribution(bf_RandomVariable **pX, int N, bf_RandomGenerator *rng)
  {

    create(N,rng);

    for(long int i=0;i<N;i++)
    {
      m_pSampleSet[i] = pX[i];
      m_pWeights[i] = (real)1/N;
      m_pCumWeights[i] = (real)i/N;
      m_dTotalCumWeight = 1.0;
    }    

  }
   

  //----- overloaded constructor: receives a pointer to RV that are stored as an array
 
  bf_ParticleDistribution::bf_ParticleDistribution(bf_RandomVariable *pX, int N, 
						   bf_RandomGenerator *rng)
  {

    create(N,rng);

    for(long int i=0;i<N;i++)
    {
      m_pSampleSet[i] = &pX[i];
      m_pWeights[i] = (real)1/N;
      m_pCumWeights[i] = (real)i/N;
      m_dTotalCumWeight = 1.0;
    }    

  }


  //----- 
 
  void bf_ParticleDistribution::create(int N,bf_RandomGenerator *rng)
  {

    // printf("Create base Partcil %d \n",N);

    if(N>0){
      m_pSampleSet = (bf_RandomVariable**) malloc(N * sizeof(bf_RandomVariable*));
      m_pWeights = (real *) malloc(N * sizeof(real));
      m_pCumWeights = (real *) malloc(N * sizeof(real));
    }
    else {
      m_pSampleSet = NULL;
      m_pWeights = NULL;
      m_pCumWeights = NULL;
    }
    m_iNumberOfSamples = N;
    //assume rng!= NULL
    m_pRng=rng;

    //printf("Create base Partcil Nber of samples %d \n",m_iNumberOfSamples);

  }

  //-----
  void bf_ParticleDistribution::init(void)
  {

    for(long int i=0;i<m_iNumberOfSamples;i++)
    {
      m_pWeights[i] = (real)1/m_iNumberOfSamples;
      m_pCumWeights[i] = (real)i/m_iNumberOfSamples;
      m_dTotalCumWeight = 1.0;
    }    
  }

  //possibly overload init() with one that receives directly with a parametric prior

  
  //-----
  void bf_ParticleDistribution::reset(bf_SampleDist *sampler){

    init(); // initialize weights uniformly

    // generate new samples
    sampler->sampleRV_N(m_pSampleSet,m_iNumberOfSamples);

  }    
    
  //-----
  // return the index of the particle with highest weight
  int bf_ParticleDistribution::getMode(){
    real mw=-1;
    int  indexmax=-1;
    int i;
    for(i=0;i<m_iNumberOfSamples;i++)
      if(m_pWeights[i]>mw){
	mw=m_pWeights[i];
	indexmax=i;
      }
    return indexmax;
  }
  

    
  //-----       
  void bf_ParticleDistribution::sampleParticle(bf_RandomVariable **pX)
  {    	
	  
    if(m_pCumWeights == NULL)	
      error ("Vector of CumulativeWeights in class ParticleDistribution has to be initialized");           
    else
      *pX = m_pSampleSet[ SampleBinarySearch() ];	

  } // sample()


  //-----       
  void bf_ParticleDistribution::sampleParticleIndex(bf_RandomVariable **pX,int *index)
  {    	
	  
    if(m_pCumWeights == NULL)	
      error ("Vector of CumulativeWeights in class ParticleDistribution has to be initialized");           
    else {
		*index= SampleBinarySearch();
      *pX = m_pSampleSet[*index];
	 }
	 

  } // sample()


  //----- 
  void bf_ParticleDistribution::sampleParticleN(bf_RandomVariable **pX, int N)	
  {    

    if(m_pCumWeights == NULL)	
      error ("Vector of Cumulative Weights in class ParticleDistribution has to be initialized");           
    else
      for(int i=0;i<N;i++)
	pX[i] = m_pSampleSet[ SampleBinarySearch() ];

  } // sampleN()



  //-----       
  int bf_ParticleDistribution::SampleBinarySearch(void)	
  {    	

    real choice = m_pRng->uniform() * m_dTotalCumWeight;
    int low, middle, high;

    low = 0;
    high = m_iNumberOfSamples; 
         
    while (high>(low+1))          
    {	   
      middle = (high+low)/2;
      if (choice > m_pCumWeights[middle])
	low = middle;
      else 
	high = middle;
    }
    return low;

  } // SampleBinarySearch()


  //----- PENDING!
  real bf_ParticleDistribution::evaluate(bf_RandomVariable *pX)
  {
    return 0;
  }


  //-----
  // set the seed used for sampling
  void bf_ParticleDistribution::setSeed(unsigned long seed)
  {
    m_pRng->manualSeed(seed);
  }

  //-----
  // get the seed used for sampling
  /*  long bf_ParticleDistribution::getSeed(void)
  {
    return m_pRng->get_seed();
  }
  */


  //-----
  bf_ParticleDistribution::~bf_ParticleDistribution()
  {
    if(m_pSampleSet!=NULL)
      free(m_pSampleSet);
    if(m_pWeights!=NULL)
      free(m_pWeights);
    if(m_pCumWeights)
      free(m_pCumWeights);
  }

}
