#ifndef BF_MIXEDPARTICLEDISTRIBUTION_INC
#define BF_MIXEDPARTICLEDISTRIBUTION_INC

#include "general.h"
#include "bf_ParticleDistribution.h"

namespace Torch {

//-----

/** 

    In that case, random variables are composed
    of :
    
    Begin of the list :
    - n ptrs to vectors (called elements) 
       of reals (the number n indicates the size of each)
    - the last pointer (if any) is a pointer on int
    
    The memory is allocated here.

    @author Jean-Marc Odobez (Jean-Marc.Odobez@idiap.ch)
    @author Daniel Gatica-Perez (gatica@idiap.ch)
*/

  class bf_MixedParticleDistribution : public bf_ParticleDistribution
    {
    public:
      int                   m_iNbOfRealElements;
      int                  *m_pSizeOfRealElements;
      int                   m_iSizeOfIntElement;
      
    private:
      int                   m_iSizeOfStorageReal;
      int                   m_iSizeOfStorageInt;
      real                 *m_pStorageReal;
      int                  *m_pStorageInt;
      bf_RandomVariable    *m_pRVTable;

    public:

      //---     Constructors 

      /// creates a particle distribution pointing to N samples
      bf_MixedParticleDistribution(int N, int NbOfRealElements,
				   int *_pSizeOfElements,
				   int _SizeOfIntElement,
				   bf_RandomGenerator *rng);
      
      /// creates a particle distribution pointing to N samples
      bf_MixedParticleDistribution(int N, int NbOfRealElements,
				   int _SizeOfElements,
				   int _SizeOfIntElement,
				   bf_RandomGenerator *rng);
      
      // creates the memory necessary for managing  N particles
      // WARNING : IT ONLY CREATES THE ADDITIONAL MEMORY
      // (not the one necessary for the base class)

    private:
      virtual void create(int N,int NbOfRealElements,
			  int *_pSizeOfElements,
			  int _SizeOfIntElement);
      
    public:
      
      //-----
      // OK : lets define a resetZero function
      
      virtual void resetZero();

      //-----
      // to initialize the given element [0,NbOfRealElements-1]
      // When the element is specified, only that element is initialized
      // The Int version is to be used for the Int element
      virtual void getSample(real *values,int particle,int element);
  
      virtual void setSample(real *values,int particle,int element=-1);
      virtual void setSampleInt(int *values,int particle);
      virtual void setAllSample(real *values,int element=-1);
      virtual void setAllSampleInt(int *values);

      //--------------------------------
      // To get some statistics on states
      virtual void getMeanVariance(real *mean,real *variance,int element=-1);

      
      //-----
      // and the display function of one particle
      
      virtual void displaySample(int i,char *com="");
      
      //-----
      // and a display function
      
      virtual void display(char *com);
      
      //-----
      virtual ~bf_MixedParticleDistribution();

    
  };

}

#endif
