#ifndef BF_LIKELIHOOD_PRODUCT_INC
#define BF_LIKELIHOOD_PRODUCT_INC

#include "general.h"
#include "bf_RandomVariable.h"
#include "bf_RandomGenerator.h"
#include "bf_DistributionReal.h"



namespace Torch {
  //-----

  /** 

      
    
      @author Jean-marc Odobez (Jean-Marc.Odobez@idiap.ch)
      @author Daniel Gatica-Perez (gatica@idiap.ch)
  */
  //===================================================
  //
  //    class         bf_LikelihoodProduct
  //
  //    p(Z|X) = Prod_i  ( p_i ( Zi | X ) )
  //
  //===================================================

  class   bf_LikelihoodProduct : public bf_EvalCondDist {
  public:
    bf_EvalCondDist         **m_pLikelihood;
    int                      *m_pObservationData; 
    // m_pObservationData[i] tells which data item (element of the list
    // of the Z variable) corresponds to likelihood m_pLikelihood[i]
    int                      m_iNumberOfLikelihoods;

  private:
    bf_RandomVariable        m_cZ; // will contain a pointer (in turn) to 
    // individual data
    
  public:
    //-----
    bf_LikelihoodProduct(bf_EvalCondDist  **pLikelihoods,
			 int               *pDataItem,
			 int               NumberOfLikelihoods);

    //----
    virtual void  create(bf_EvalCondDist  **pLikelihoods,
			 int               *pDataItem,
			 int               NumberOfLikelihoods);

    //----
    virtual void  freeMemory();

    //----
    virtual inline real evaluateConditionalRV(bf_RandomVariable *pZ,bf_RandomVariable *pX){
      int i,j;
      real p=1.;
      for(i=0;i<m_iNumberOfLikelihoods;i++) {
	j=m_pObservationData[i];
	m_cZ.m_cData.nodes[0]=(real *)pZ->m_cData.nodes[j];
	p *= m_pLikelihood[i]->evaluateConditionalRV(&m_cZ,pX);
      }
      return p;
    }

    //----
    virtual ~bf_LikelihoodProduct();


  };

   
}

#endif
