#ifndef BF_DYNAMICMODEL_INC
#define BF_DYNAMICMODEL_INC

#include "general.h"
#include "Distribution.h"
#include "bf_PredictModel.h"

namespace Torch {

  //-----
  /*
       Some  specific  dynamical  model (for real essentially)

  */

  //===================================================
  //
  //   class    bf_AdditivePredictModelReal
  //  
  //     Additive Gaussian noise prediction model
  //     This fundemental model for linear/linearised filtering
  //     x(k|k-1) = f(x(k-1|k-1)) + G(k)w(k)
  //     q(k) = state noise covariance, q(k) is covariance of w(k)
  //     G(k) = state noise coupling
  //
  //===================================================
  class bf_AdditivePredictModelReal : 
    virtual public    bf_SamplePredictModelReal 
    {

    public:
      Vec   q;		// Noise Covariance
      Mat   G;		// Noise Coupling

    public:
      Vec  m_vecNoise;      // contains the noise components of the samples
      Vec  m_vecBaseNoise;  // noise vector      

    public:

       bf_AdditivePredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng=NULL);
      
      bf_AdditivePredictModelReal (Mat *_G,Vec *_q,bf_RandomGenerator *_rng=NULL);
      
      //--------
      // MEMORY SHOULD BE ALREADY ALLOCATED
      // generating a sample according to P ( X | Y)
      virtual  void sampleConditionalReal(real *pX, real *pY=NULL);
    
      //--------
      inline virtual  void fPredictReal(real *pX, real *pY)=0;
      
      //--------
      virtual void  fNoiseReal(real *noise, real *conditional=NULL);
      
      //--------
      virtual ~bf_AdditivePredictModelReal(){}
      
    };


  //===================================================
  //
  //   class          bf_LinrzPredictModelReal
  //
  //  Linrz prediction model Fx, f about state x (fixed size)
  //  x(k|k-1) = f(x(k-1|k-1)
  //  Fx(x(k-1|k-1) = Jacobian of f with respect to state x
  //
  //===================================================
  
  class bf_LinrzPredictModelReal : public bf_AdditivePredictModelReal
    {
    public:
      bf_LinrzPredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng=NULL);
      bf_LinrzPredictModelReal(Mat *_G,Vec *_q,Mat *_Fx ,bf_RandomGenerator *_rng=NULL);
     
      Mat Fx;		// Model

      virtual ~bf_LinrzPredictModelReal() {}
      
    };



 //===================================================
 //
 //  class     bf_LinearPredictModelReal
 //
 //===================================================
 class bf_LinearPredictModelReal : public bf_LinrzPredictModelReal
   /* Linear prediction model Fx about state x (fixed size)
      x(k|k-1) = Fx(k-1|k-1) * x(k-1|k-1)
   */
   {
   public:
     bf_LinearPredictModelReal(int x_size, int q_size,bf_RandomGenerator *_rng=NULL);

     /* Set constant sizes for
	x_size of the state vector
	q_size of the noise vector
	Postcondition:
	Fx, q and G are conformantly dimensioned
     */

     bf_LinearPredictModelReal(Mat *_G,Vec *_q,Mat *_Fx,bf_RandomGenerator *_rng=NULL);    
 
     // Provide a linear implementation of functional f assumes model is already Linrz for Fx
     virtual void fPredictReal(real *xpred, real *x);
 
     virtual ~bf_LinearPredictModelReal() {}
    };
 

}  // Namspace Torch

#endif
