% Copyright (c) 2016 Idiap Research Institute, http://www.idiap.ch/
% Written by Edgar Roman-Rangel, et al
% 
% This file is part of HOOSC implementation.
% 
% HOOSC is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 3 as
% published by the Free Software Foundation.
% 
% Foobar is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with Foobar. If not, see <http://www.gnu.org/licenses/>.

function H = orientationKernel(numOfOrientations, numOfBins, sigma)


%% Find the size of each Gaussian kernel
numDumm = numOfOrientations;
while(mod(numDumm, numOfBins) ~= 0)
    numDumm = 2 * numDumm;
end
binSize = numDumm / numOfBins;


%% Compute central Gaussian
pivot = round(numOfOrientations / 2);
G = zeros(numOfOrientations, numDumm);
G(pivot, :) = pdf('norm', 1 : numDumm, round(numDumm / 2), sigma);
H = zeros(numOfOrientations, numOfBins);

bin = 1;
for b = 1 : numOfBins
	H(pivot, b) = sum(G(pivot, bin : bin + binSize - 1));
	bin = bin + binSize;
end


%% Compute the other Gaussians
for h = pivot + 1 : numOfOrientations
    G(h, :) = circshift(G(h - 1, :), [0, (numDumm / numOfOrientations)]);
    bin = 1;
    for b = 1 : numOfBins
        H(h, b) = sum(G(h, bin : bin + binSize - 1));
        bin = bin + binSize;
    end
end
for h = pivot - 1 : -1 : 1
    G(h, :) = circshift(G(h + 1, :), [0, -(numDumm / numOfOrientations)]);
    bin = 1;
    for b = 1 : numOfBins
        H(h, b) = sum(G(h, bin : bin + binSize - 1));
        bin = bin + binSize;
    end
end


%% Keep only the most probable bins
[~, idSortH] = sort(H, 2);
for h = 1 : numOfOrientations
    H(h, idSortH(h, 1 : end - 4)) = 0;
end

end
